#pragma once
#include <Windows.h>
#include <vector>
#include <deque>
#include "GVONavish.h"
#include "GVOVector.h"
#include "GVOVelocity.h"





class GVOShip {
private:
	typedef std::deque<GVOVector> VectorArray;

private:
	POINT m_surveyCoord;		//!<@brief ŐVW
	GVOVector m_vector;			//!<@brief D̃xNg

	VectorArray m_vectorArray;
	double m_velocity;
	uint32_t m_timeStamp;
	GVOVelocity m_velocityPerSecond;

public:
	GVOShip() :
		m_surveyCoord(),
		m_velocity(),
		m_timeStamp()
	{
	}

	inline void setInitialSurveyCoord( const POINT& initialSurveyCoord )
	{
		m_surveyCoord = initialSurveyCoord;
	}

	//!@brief D̕Lǂ
	inline bool isVectorEnabled() const
	{
		return m_vector.length() != 0.0;
	}

	inline const GVOVector& vector() const
	{
		return m_vector;
	}

	//!@brief ʍWɂŐVʒuXV
	void updateWithSurveyCoord( const POINT& surveyCoord, const uint32_t timeStamp );

	//!@brief _ƃxNgw肵čW𓾂
	POINT pointFromOriginWithLength( const POINT& origin, const LONG length ) const
	{
		GVOVector v = m_vector.normalizedVector();
		const POINT p = {
			origin.x + LONG( v.x() * length ),
			origin.y + LONG( v.y() * length )
		};
		return p;
	}

	inline double velocity() const
	{
		return m_velocityPerSecond.velocity();
	}
};
