#include "stdafx.h"
#include <string>
#include "GVOShip.h"

namespace {
	// Q[pxiQxxjɊۂ߂
	inline double s_roundInGameAngle( const double radian )
	{
		double degree = g_degreeFromRadian( radian );
		degree = ::floor( ::round( degree ) * 0.5 ) * 2.0;
		return g_radianFromDegree( degree );
	}
	inline GVOVector s_roundInGameVector( const GVOVector& v )
	{
		// ^̊px擾
		double sita = GVOVector( 1, 0 ).angleTo( v );
		// 2x360x\Ɋۂ߂
		sita = s_roundInGameAngle( sita );
		// ʓxɖ߂
		// EWn͏オ0Ȃ̂Y𔽓]
		return GVOVector( ::cos( sita ), -::sin( sita ) );
	}

	// ̃xNgŕ\oQ[p̕\Zo
	inline double s_resolutionForVector( const GVOVector& vector )
	{
		const double length = ::fabs( vector.length() );
		if ( length == 0.0 ) {
			return 0.0;
		}
		if ( length < 2 ) {
			return g_radianFromDegree( 90 + 90 / 2 );
		}
		if ( 90.0 <= length ) {
			return M_PI_2 / 90.0;	// Qxō
		}
		const double resolution = M_PI_2 / length;
		return resolution;
	}

	inline bool s_isAnotherDirection( const GVOVector& v1, const GVOVector& v2 )
	{
		const double resolution = s_resolutionForVector( v2 );
		const double angle = v1.angleTo( v2 );
		return resolution < ::fabs( angle );
	}
}


void GVOShip::updateWithSurveyCoord( const POINT& surveyCoord, const uint32_t timeStamp )
{
	const GVOVector v( m_surveyCoord, surveyCoord );

	m_velocity = v.length();
	m_velocityPerSecond.setVelocity( m_velocity, timeStamp - m_timeStamp );
	m_timeStamp = timeStamp;

	// ړĂȂΖB
	if ( m_velocity == 0.0 ) {
		return;
	}
	m_surveyCoord = surveyCoord;

	// ݂̃xNgݒ肳ĂȂ΃p[^[̂܂܍̗p
	if ( m_vector.length() == 0.0 ) {
		m_vector = s_roundInGameVector( v.normalizedVector() );
		return;
	}

	// VقȂpxƌȂxNgT
	GVOVector headVector = v;
	for ( VectorArray::const_reverse_iterator it = m_vectorArray.rbegin(); it != m_vectorArray.rend(); ++it ) {
		headVector.composite( *it );
		if ( s_isAnotherDirection(m_vector, headVector) ) {
			// ȍ~͎QlɂȂȂ̂ō폜B
			m_vectorArray.erase( m_vectorArray.begin(), std::next( it ).base() );
			break;
		}
	}
	m_vector = s_roundInGameVector( headVector.normalizedVector() );

	// ŐṼxNgXgɉB
	m_vectorArray.push_back( v );

	// vZ90Ε\180̊pxZoł͂덷𓥂܂2{̋ێĂ
	if ( 180 < (headVector.length() - m_vectorArray.front().length()) ) {
		m_vectorArray.pop_front();
	}
}
