import javax.swing.*;
import javax.swing.table.*;
import java.awt.Component;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.*;
import java.util.List;
import java.util.Iterator;
import javax.swing.border.*;

public class StatusBrowser extends JFrame
{
	private static final long serialVersionUID = 2L;
	private static final String version = "Ganbaride Status Browser ver 2.0";
	StatusBrowserModel model;

	public static final int APP_SIZE_WIDTH       = 600;
	public static final int APP_SIZE_HEIGHT      = 500;
	public static final int SELPANEL_SIZE_HEIGHT = 25;
	public static final int SELPANEL_CARDNUM_SIZE_WIDTH = 75;
	public static final int SELPANEL_RIDER_NAME_WIDTH   = 275;
	public static final int SELPANEL_STBUTTON_WIDTH     = 25;
	public static final int RESPANEL_RIDER_NAME_WIDTH   = 250;
	
	StatusBrowser(String label) 
	{
		super(label);
		model = new StatusBrowserModel();
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(APP_SIZE_WIDTH, APP_SIZE_HEIGHT);
		
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
		
		// [GCAREGCIppl쐬
		final RiderSelectionPanel vanguard  = new RiderSelectionPanel("[GC@F", this.model);
		final RiderSelectionPanel supporter = new RiderSelectionPanel("T|[^[F", this.model);
		final RiderSelectionPanel breaker   = new RiderSelectionPanel("uCJ[F", this.model);
		
		// Filter
		final FilterPanel filter = new FilterPanel();
		setEnabled(filter, false);
		
		// Options
		final OptionPanel options = new OptionPanel();
		setEnabled(options, false);
		
		// Check ModeIpl쐬
		JPanel modeSelection = new JPanel();
		JRadioButton[] modeButton = new JRadioButton[4];
		modeButton[0] = new JRadioButton("RlI", true);
		modeButton[1] = new JRadioButton("[GĈݑI");
		modeButton[2] = new JRadioButton("T|[^[̂ݑI");
		modeButton[3] = new JRadioButton("uCJ[̂ݑI");
		modeButton[0].addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setEnabled(vanguard,  true);
				setEnabled(supporter,true);
				setEnabled(breaker,true);
				setEnabled(filter,    false);
				setEnabled(options,   false);
			}
		});
		modeButton[1].addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setEnabled(vanguard,  true);
				setEnabled(supporter, false);
				setEnabled(breaker,   false);
				setEnabled(filter,    true);
				setEnabled(options,   true);
			}
		});
		modeButton[2].addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setEnabled(vanguard,  false);
				setEnabled(supporter, true);
				setEnabled(breaker,   false);
				setEnabled(filter,    true);
				setEnabled(options,   true);
			}
		});
		modeButton[3].addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setEnabled(vanguard,  false);
				setEnabled(supporter, false);
				setEnabled(breaker,   true);
				setEnabled(filter,    true);
				setEnabled(options,   true);
			}
		});
		ButtonGroup group = new ButtonGroup();
		group.add(modeButton[0]);
		group.add(modeButton[1]);
		group.add(modeButton[2]);
		group.add(modeButton[3]);
		modeSelection.setLayout(new BoxLayout(modeSelection, BoxLayout.X_AXIS));
		modeSelection.add(modeButton[0]);
		modeSelection.add(modeButton[1]);
		modeSelection.add(modeButton[2]);
		modeSelection.add(modeButton[3]);

		// ʕ\pl쐬
		final String[] columnName = {"[GC", "T|[^[", "uCJ[", "U", "h", "", "K"};
		final DefaultTableModel tableModel = new DefaultTableModel(columnName, 0);
		JTable statusTable = new JTable(tableModel);
		DefaultTableColumnModel columnModel = (DefaultTableColumnModel)statusTable.getColumnModel();
		columnModel.getColumn(0).setPreferredWidth(RESPANEL_RIDER_NAME_WIDTH);
		columnModel.getColumn(1).setPreferredWidth(RESPANEL_RIDER_NAME_WIDTH);
		columnModel.getColumn(2).setPreferredWidth(RESPANEL_RIDER_NAME_WIDTH);
		statusTable.setDefaultEditor(Object.class, null); // Not Editable!!
		JPanel result    = new JPanel();
		result.setLayout(new BorderLayout());
		JScrollPane scroller = new JScrollPane(statusTable);
		result.add(scroller, BorderLayout.CENTER);
		JButton clearButton = new JButton("ʃNA");
		clearButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				while(tableModel.getRowCount() != 0) {
					tableModel.removeRow(0);
				}
			}
		});
		result.add(clearButton, BorderLayout.SOUTH);
		JButton checkButton = new JButton("Xe[^X`FbN");
		result.add(checkButton, BorderLayout.NORTH);
		checkButton.addActionListener(new CheckAction(vanguard, supporter, breaker, model, tableModel, modeButton, filter, options));
				
		p.add(modeSelection);
		p.add(new JSeparator());
		p.add(Box.createRigidArea(new Dimension(5, 5)));
		p.add(vanguard);
		p.add(supporter);
		p.add(breaker);
		p.add(Box.createRigidArea(new Dimension(10, 10)));
		p.add(filter);
		p.add(Box.createRigidArea(new Dimension(5, 5)));
		p.add(options);
		p.add(Box.createRigidArea(new Dimension(5, 5)));
		p.add(result);
		
		getContentPane().add(p);
	}

	public static void main(String[] args) 
	{
		StatusBrowser browser = new StatusBrowser(version);
		browser.setVisible(true);
	}
	
	public static final void setEnabled(JComponent component, boolean enabled) {
	    Component[] children = component.getComponents();
	    for (int i = 0; i < children.length; ++i) {
	        if (children[i] instanceof JComponent) {
	            setEnabled((JComponent) children[i], enabled);
	        }
	    }
	    component.setEnabled(enabled);
	}
}

class RiderSelectionPanel extends JPanel {
	private static final long serialVersionUID = 1L;

	private JComboBox series;
	private JComboBox numbers;
	private StatusBrowserModel model;
	private StatusDialog       dialog;
	
	RiderSelectionPanel(String str, final StatusBrowserModel model) {
		this.model = model;
		List<String> seriesList = this.model.getSeriesList();
		JLabel label = new JLabel(str);
		setMaximumSize(new Dimension(Short.MAX_VALUE, StatusBrowser.SELPANEL_SIZE_HEIGHT));

		series  = new JComboBox(seriesList.toArray());
		series.setMaximumSize(new Dimension(StatusBrowser.SELPANEL_CARDNUM_SIZE_WIDTH, Short.MAX_VALUE));
		series.setPreferredSize(new Dimension(StatusBrowser.SELPANEL_CARDNUM_SIZE_WIDTH, StatusBrowser.SELPANEL_SIZE_HEIGHT));

		numbers = new JComboBox();
		numbers.setMaximumSize(new Dimension(StatusBrowser.SELPANEL_CARDNUM_SIZE_WIDTH, Short.MAX_VALUE));
		numbers.setPreferredSize(new Dimension(StatusBrowser.SELPANEL_CARDNUM_SIZE_WIDTH, StatusBrowser.SELPANEL_SIZE_HEIGHT));

		final JLabel name    = new JLabel();
		name.setMaximumSize(new Dimension(StatusBrowser.SELPANEL_RIDER_NAME_WIDTH, Short.MAX_VALUE));
	
		JButton stButton = new JButton("c");
		stButton.setMaximumSize(new Dimension(StatusBrowser.SELPANEL_STBUTTON_WIDTH, Short.MAX_VALUE));
		stButton.setPreferredSize(new Dimension(StatusBrowser.SELPANEL_STBUTTON_WIDTH, StatusBrowser.SELPANEL_SIZE_HEIGHT));
	
		dialog = new StatusDialog();
		
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		add(label);
		add(series);
		add(new JLabel("|"));
		add(numbers);
		add(Box.createRigidArea(new Dimension(10,10)));
		add(name);
		add(Box.createHorizontalGlue());
		add(stButton);

		series.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String selectedSeries = (String)series.getSelectedItem();
				List<String> nums = model.getNumberList(selectedSeries);
				numbers.removeAllItems();
				Iterator<String> i = nums.iterator();
				while(i.hasNext()) {
					numbers.addItem(i.next());
				}
			}
		});
		
		numbers.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				name.setText("");
				Rider r = getSelectedRider();
				if(r != null) {
					name.setText(r.getName());
				}
			}
		});
		
		stButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				Rider r = getSelectedRider();
				if(r != null) {
					dialog.setRider(r);
					dialog.setVisible(true);
				}
			}
		});
	}
	
	public Rider getSelectedRider() {
		Rider rider = null;
		String s = (String)series.getSelectedItem();
		String n = (String)numbers.getSelectedItem();
		if(s != null && n != null) {
			rider = model.search(s, Integer.parseInt(n));
		}
		return rider;
	}
}

class StatusDialog extends JDialog implements ActionListener {
	private static final long serialVersionUID = 1L;
	public  static final int  DIALOG_DEFAULT_WIDTH  = 400;
	public  static final int  DIALOG_DEFAULT_HEIGHT = 300;
	private static final String format =
"<html><head><style type=\"text/css\"><!--table{font-family : \"MS UI Gothic\"; border-style:\"solid\";} td{border-style:\"solid\";}--></style></head><body><h1>%s</h1>" +
"<div align=\"center\"><table border=1>" +
"<tr><td></td><td>%s-%3d</td><td>%s</td><td>%s</td></tr>" +
"<tr><td rowspan=2><strong>Xe[^X</strong></td><td>REQL %d</td><td>{EM %d</td><td>^CN %d</td></tr>" +
"<tr><td colspan=3>qbTc %d</td></tr>" +
"<tr><td><strong>REGC</strong></td><td colspan=3>%s</td></tr>" +
"<tr><td><strong></strong></td><td colspan=3>KiU%dAh%dA%dAK%dj</td></tr>" +
"</table></div>" +
"</body></html>";
	
	JEditorPane browser;
	
	StatusDialog() {
		super();
		browser = new JEditorPane();
		browser.setEditable(false);
		browser.setContentType("text/html");
		
		JButton button = new JButton("OK");
		button.addActionListener(this);
		
		getContentPane().add(button,  BorderLayout.SOUTH);
		getContentPane().add(browser, BorderLayout.CENTER);

		setTitle("Xe[^X\");
		setSize(DIALOG_DEFAULT_WIDTH, DIALOG_DEFAULT_HEIGHT);
		setVisible(false);
	}
	
	void setRider(Rider r) {
		setSize(DIALOG_DEFAULT_WIDTH, DIALOG_DEFAULT_HEIGHT);
		browser.setText(String.format(format, 
				r.getName(), r.getSeries(), r.getNumber(), getRarityString(r.getRarity()), getAttrString(r.getAttribute()),
				r.getOffense(), r.getDefense(), r.getHitpoint(),
				r.getSpecialAttack(),
				getRearGuardTacticsString(r.getRearGuardTactics()),
				r.getChemistry(Rider.CHEMISTRY_INDEX_OFFENSE), r.getChemistry(Rider.CHEMISTRY_INDEX_DEFENSE), r.getChemistry(Rider.CHEMISTRY_INDEX_HITPOINT), r.getChemistry(Rider.CHEMISTRY_INDEX_SP_ATTACK)));
		
	}
	
	public void actionPerformed(ActionEvent e) {
		setVisible(false);
	}
	
	private String getAttrString(int attr) {
		String prefix = ((attr & Rider.ATTR_SUPER_MASK) == Rider.ATTR_SUPER_MASK) ? "" : "";
		switch(attr & ~Rider.ATTR_SUPER_MASK) {
		case Rider.ATTR_SPEED: return "<font color=\"#0000FF\"><strong>" + prefix + "" + "</strong></font>";
		case Rider.ATTR_POWER: return "<font color=\"#FF0000\"><strong>" + prefix + "" + "</strong></font>";
		default:               return "<font color=\"#30A000\"><strong>" + prefix + "Z" + "</strong></font>";
		}		
	}
	
	private String getRarityString(int rarity) {
		switch(rarity) {
		case Rider.RARITY_LEGEND_RARE: return "LR";
		case Rider.RARITY_SUPER_RARE:  return "SR";
		case Rider.RARITY_RARE:        return "R";
		default:                       return "N";
		}
	}
	
	private String getRearGuardTacticsString(int rgt) {
		switch(rgt) {
		case Rider.GANGAN_SEMERO:       return "KKZ";
		case Rider.AITE_WO_BUTTOBASE:   return "ACeubgoZ";
		case Rider.SUPPORT_HA_MAKASERO: return "T|[gn}JZ";
		case Rider.AITE_WO_YOKUMIRO:    return "ACeN~";
		default:                        return "K[hJ^";
		}
	}
}

class FilterPanel extends JPanel {
	private static final long serialVersionUID = 1L;
	
	private JTextField offense, defense, hitpoint, spAttack;
	
	FilterPanel() {
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		add(new JLabel("U"));
		add(offense = new JTextField("0", 4));
		add(new JLabel("ȏA@h"));
		add(defense = new JTextField("0", 4));
		add(new JLabel("ȏA@"));
		add(hitpoint = new JTextField("0", 4));
		add(new JLabel("ȏA@K"));
		add(spAttack = new JTextField("0", 4));
		add(new JLabel("ȏ"));
		setBorder(new TitledBorder(new EtchedBorder(), "tB^["));
		offense.setHorizontalAlignment(SwingConstants.RIGHT);
		defense.setHorizontalAlignment(SwingConstants.RIGHT);
		hitpoint.setHorizontalAlignment(SwingConstants.RIGHT);
		spAttack.setHorizontalAlignment(SwingConstants.RIGHT);
	}
	
	Filter getFilter() {
		int o = 0, d = 0, h = 0, s = 0;
		try {o = Integer.parseInt(offense.getText()); } catch(Exception e){o = 0;}
		try {d = Integer.parseInt(defense.getText()); } catch(Exception e){d = 0;}
		try {h = Integer.parseInt(hitpoint.getText());} catch(Exception e){h = 0;}
		try {s = Integer.parseInt(spAttack.getText());} catch(Exception e){s = 0;}
		return new Filter(o, d, h, s, 50);
	}
}

class OptionPanel extends JPanel {
	private static final long serialVersionUID = 1L;
	private JComboBox sortIndex;

	OptionPanel() {
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		sortIndex = new JComboBox();
		sortIndex.setMaximumSize(new Dimension(100, 100));
		sortIndex.addItem("REQL");
		sortIndex.addItem("{EM");
		sortIndex.addItem("^CN");
		sortIndex.addItem("qbTc");
		sortIndex.addItem("Ȃ");
		add(new JLabel("IvVF@"));
		add(new JLabel("\[g"));
		add(sortIndex);
	}

	public int getSortIndex() {return sortIndex.getSelectedIndex();}
}

class CheckAction implements ActionListener {
	private RiderSelectionPanel vanguard;
	private RiderSelectionPanel supporter;
	private RiderSelectionPanel breaker;
	private StatusBrowserModel  model;
	private DefaultTableModel   tableModel;
	private JRadioButton[]      modeButton;
	private FilterPanel         filter;
	private OptionPanel         options;
	
	CheckAction(RiderSelectionPanel vanguard, RiderSelectionPanel supporter, RiderSelectionPanel breaker, StatusBrowserModel model, DefaultTableModel tableModel, JRadioButton[] modeButton, FilterPanel filter, OptionPanel options) {
		this.vanguard   = vanguard;
		this.supporter  = supporter;
		this.breaker    = breaker;
		this.model      = model;
		this.tableModel = tableModel;
		this.modeButton = modeButton;
		this.filter     = filter;
		this.options    = options;
	}
	
	public void actionPerformed(ActionEvent e) {
		Rider r1 = vanguard.getSelectedRider();
		Rider r2 = supporter.getSelectedRider();
		Rider r3 = breaker.getSelectedRider();
		if(modeButton[0].isSelected()) {
			if(r1 != null && r2 != null && r3 != null && 
			   !r1.getName().equals(r2.getName()) && !r1.getName().equals(r3.getName()) && !r2.getName().equals(r3.getName())) {
				Rider status = model.getStatus(r1, r2, r3);
				tableModel.addRow(new Object[]{r1.toString(), r2.toString(), r3.toString(), status.getOffense(), status.getDefense(), status.getHitpoint(), status.getSpecialAttack()});
			}
		} else {
			Rider rider = null;
			int riderPos = Rider.POS_VANGUARD;
			if(modeButton[1].isSelected()) {
				rider = r1;
			} else if(modeButton[2].isSelected()) {
				rider = r2; riderPos = Rider.POS_SUPPORTER;
			} else if(modeButton[3].isSelected()) {
				rider = r3; riderPos = Rider.POS_BREAKER;
			}
			if(rider != null) {
				List<DeckStatus> list = model.getStatusList(rider, riderPos, filter.getFilter(), options.getSortIndex());
				Iterator<DeckStatus> i = list.iterator();
				while(i.hasNext()) {
					DeckStatus status = i.next();
					Rider van = status.getVanguard();
					Rider spt = status.getSupporter();
					Rider brk = status.getBreaker();
					tableModel.addRow(new Object[]{van.toString(), spt.toString(), brk.toString(), status.getOffense(), status.getDefense(), status.getHitpoint(), status.getSpecialAttack()});
				}
			}
		}
	}
}