#include "libwilmaops.h"

static void FillExpandedLine(byte* destBuffer,
		                      int destPixelStride, int destWidth,
		                      byte* srcBuffer,
		                      int srcOffset, int srcPixelStride,  
                              int origSrcWidth,
		                      int numChannels, int srcScale, int destScale) {
	int subsampledWidth = (int)((long)destWidth * destWidth * srcScale / destScale);
	int srcWidth = subsampledWidth / destWidth;
	subsampledWidth = srcWidth * destWidth; // re-calculation.
	int xInSubSampledCoord = 0;
	int xInSrcCoord = 0;
	int xInDestCoord = 0;
	int xOfNextGridInSrcCoord = destWidth;
	int destOffset = 0;
	int c;

	while (xInSubSampledCoord < subsampledWidth) {
		int step = srcWidth;
		int stepInSrcCoord = 0;
		
		if (xInSubSampledCoord + srcWidth < xOfNextGridInSrcCoord) {
			// pass

		} else if (xInSubSampledCoord + srcWidth == xOfNextGridInSrcCoord) {
			stepInSrcCoord = 1;
			xOfNextGridInSrcCoord += destWidth;

		} else {
			step = xOfNextGridInSrcCoord - xInSubSampledCoord;
			stepInSrcCoord = 1;
			xOfNextGridInSrcCoord += destWidth;
		}
		
		if (xInSrcCoord < origSrcWidth) {
			for (c = 0; c < numChannels; c ++)
				destBuffer[destOffset + c] = srcBuffer[srcOffset+c];
		} else {
			// Src is out of buffer.
//					Console.WriteLine("x in src="+xInSrcCoord+",x in dest="+xInDestCoord+",dest width="+destWidth+",src width="+srcWidth);
			for (c = 0; c < numChannels; c ++)
				destBuffer[destOffset + c] = 0;
		}

		if (stepInSrcCoord > 0) {
			xInSrcCoord += stepInSrcCoord;
			srcOffset += stepInSrcCoord * srcPixelStride;
		}
		
		if (step < srcWidth) {
			if (xInSrcCoord < origSrcWidth) {
				for (c = 0; c < numChannels; c ++)
					destBuffer[destOffset + c] = (byte)( (step * (int)destBuffer[destOffset+c] + (srcWidth - step) * (int)srcBuffer[srcOffset + c]) / srcWidth );
			} else {
				// Src is out of buffer.
				for (c = 0; c < numChannels; c ++)
					destBuffer[destOffset + c] = 0;
			}
		}
		destOffset += destPixelStride;
		xInSubSampledCoord += srcWidth;
		xInDestCoord  += 1;				
	}
}

void CExpand(byte* destBuffer,
             int destOffset, int destRowStride, int destPixelStride, 
             int destWidth, int destHeight,
             byte* srcBuffer,
             int srcOffset, int srcRowStride, int srcPixelStride,  
             int origSrcWidth, int origSrcHeight,
             int numChannels, int srcScale, int destScale) {

	byte intermediateBuffer[destWidth * numChannels];
	byte* filledIntermediateBuffer = null;
	int subsampledWidth = (int)((long)destWidth * destWidth * srcScale / destScale);
	int subsampledHeight = (int)((long)destHeight * destHeight * srcScale / destScale);
	int srcWidth = subsampledWidth / destWidth;
	subsampledWidth = srcWidth * destWidth; // re-calculation.
	int srcHeight = subsampledHeight / destHeight;
	subsampledHeight = srcHeight * destHeight; // re-calculation.
	int yInSubSampledCoord = 0;
	int yInSrcCoord = 0;
	int yInDestCoord = 0;
	int yOfNextGridInSrcCoord = destHeight;
	int accumulatedSamples = srcHeight * srcWidth;
	int c;
	
	memset(destBuffer + destOffset, 0, sizeof(byte) * numChannels * destWidth);

//			Console.WriteLine("destWidth ="+destWidth+", destHeight ="+destHeight);
//			Console.WriteLine("srcWidth ="+srcWidth+", srcHeight ="+srcHeight);
	
	while (yInSubSampledCoord < subsampledHeight) {
		int step = srcHeight;
		int stepInSrcCoord = 0;
		
		if (yInSubSampledCoord + srcHeight < yOfNextGridInSrcCoord) {
			// pass

		} else if (yInSubSampledCoord + srcHeight == yOfNextGridInSrcCoord) {
			stepInSrcCoord = 1;
			yOfNextGridInSrcCoord += destHeight;

		} else {
			step = yOfNextGridInSrcCoord - yInSubSampledCoord;
			stepInSrcCoord = 1;
			yOfNextGridInSrcCoord += destHeight;
		}

		// fill in intermediate buffer lines.
		if (filledIntermediateBuffer == null) {
			filledIntermediateBuffer = intermediateBuffer;
			if (yInSrcCoord < origSrcHeight) {
				FillExpandedLine(filledIntermediateBuffer, destPixelStride, destWidth, srcBuffer, srcOffset, srcPixelStride, origSrcWidth, numChannels, srcScale, destScale);
			} else {
//						Console.WriteLine("y in src="+yInSrcCoord+",height="+srcHeight);
				memset(destBuffer + destOffset, 0, sizeof(byte) * numChannels * destWidth);
			}
		}
		
		// fill in destination buffer lines.
		memcpy(destBuffer + destOffset, filledIntermediateBuffer, sizeof(byte) * destWidth * numChannels);

		if (stepInSrcCoord > 0) {
			srcOffset += srcRowStride;
			yInSrcCoord += stepInSrcCoord;
			filledIntermediateBuffer = null;
		}

		// blend destination buffer lines with new intermediate buffer line.
		if (step < srcHeight) {
			filledIntermediateBuffer = intermediateBuffer;
			if (yInSrcCoord < origSrcHeight) {
				FillExpandedLine(filledIntermediateBuffer, destPixelStride, destWidth, srcBuffer, srcOffset, srcPixelStride, origSrcWidth, numChannels, srcScale, destScale);
			} else {
				memset(destBuffer + destOffset, 0, sizeof(byte) * numChannels * destWidth);
			}
			// blend here.
			for (c = 0; c < destWidth * numChannels; c ++)
				destBuffer[destOffset + c] = (byte)( (step * (int)destBuffer[destOffset+c] + (srcHeight - step) * (int)filledIntermediateBuffer[c]) / srcHeight );
		}

		yInSubSampledCoord += srcHeight;
		destOffset += destRowStride;
		yInDestCoord  += 1;
	}
}

