// /home/tarai/Projects/gsaw/SubsampleOperation.cs created with MonoDevelop
// User: tarai at 17:01 2008/05/05
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Runtime.InteropServices;

namespace Holo.Operation {
	using Holo.Image;
	
	public class SubsampleOperation : TransformOperation {
		
		public SubsampleOperation() {
			this.Operator = ApplySubSample;
		}
		

		private void CopyChannels(byte[] destBuffer,
		                            int destOffset, int destRowStride, int destPixelStride, 
		                            int destWidth, int destHeight,
		                            byte[] srcBuffer,
		                            int srcOffset, int srcRowStride, int srcPixelStride,  
		                            int origSrcWidth, int origSrcHeight,
		                            int numChannels) {
			for (int y = 0; y < Math.Min(destHeight, origSrcHeight); y ++) {
				Array.Copy(srcBuffer, srcOffset, destBuffer, destOffset, destPixelStride * destWidth);
				destOffset += destRowStride;
				srcOffset += srcRowStride;
			}
		}
		
/*
		private void FillChannels(byte[] array, int offset, int w, int h, 
		                       int rowStride, int pixelStride, int numChannels,
		                       byte[] data) {
			for (int y = 0; y < h; y ++) {
				for (int x = 0; x < w; x ++) {
					for (int c = 0; c < numChannels; c++)
						array[offset+c] = data[c];
					offset += pixelStride;
				}
				offset += rowStride - pixelStride * w;
			}
		}
*/
		
#if USE_EXTERNAL_OPS
		[DllImport("libwilmaops.so")]
		static extern void CShrink(byte[] destBuffer,
		                            int destOffset, int destRowStride, int destPixelStride, 
		                            int destWidth, int destHeight,
		                            byte[] srcBuffer,
		                            int srcOffset, int srcRowStride, int srcPixelStride,  
		                            int origSrcWidth, int origSrcHeight,
		                            int numChannels, int srcScale, int destScale);
		[DllImport("libwilmaops.so")]
		static extern void CExpand(byte[] destBuffer,
		                            int destOffset, int destRowStride, int destPixelStride, 
		                            int destWidth, int destHeight,
		                            byte[] srcBuffer,
		                            int srcOffset, int srcRowStride, int srcPixelStride,  
		                            int origSrcWidth, int origSrcHeight,
		                            int numChannels, int srcScale, int destScale);
#else
		private void AccumulateShrinkedLine(int[] destBuffer,
				                            int destPixelStride, int destWidth,
				                            byte[] srcBuffer,
				                            int srcOffset, int srcPixelStride,  
		                                    int origSrcWidth,
				                            int numChannels,
		                                    int yStep) {
			int subsampledWidth = (int)((long)destWidth * destWidth * srcScale / destScale);
			int srcWidth = subsampledWidth / destWidth;
			subsampledWidth = srcWidth * destWidth; // re-calculation.
			int xInSubSampledCoord = 0;
			int xInSrcCoord = 0;
			int xInDestCoord = 0;
			int xOfNextGridInDestCoord = srcWidth;
			int numSamplesInDestPixel = 0;

			while (xInSubSampledCoord < subsampledWidth) {
				int step = destWidth;
				int stepInDestCoord = 0;
				
				if (xInSubSampledCoord + destWidth < xOfNextGridInDestCoord) {
					// pass

				} else if (xInSubSampledCoord + destWidth == xOfNextGridInDestCoord) {
					stepInDestCoord = 1;
					xOfNextGridInDestCoord += srcWidth;

				} else {
					step = xOfNextGridInDestCoord - xInSubSampledCoord;
					stepInDestCoord = 1;
					xOfNextGridInDestCoord += srcWidth;
				}
				
				numSamplesInDestPixel += step;

				if (xInSrcCoord < origSrcWidth) {
//					Console.WriteLine("X:read:bufsize="+srcBuffer.Length+"dest="+xInDestCoord+",src="+xInSrcCoord+",subsampled="+xInSubSampledCoord+",srcOffset="+srcOffset+",srcPixelStride="+srcPixelStride);
					int c = 0;
					try {
						for (c = 0; c < numChannels; c ++)
							 destBuffer[xInDestCoord * destPixelStride + c] += step * srcBuffer[srcOffset + c] * yStep;
					} catch (Exception e) {
						Console.WriteLine("X:read:destbufsize="+destBuffer.Length+",srcbufsize="+srcBuffer.Length+",dest="+xInDestCoord+"/"+destWidth+",src="+xInSrcCoord+"/"+srcWidth+",subsampled="+xInSubSampledCoord+"/"+subsampledWidth+",destOffset="+(xInDestCoord * destPixelStride + c)+",srcOffset="+srcOffset+",srcPixelStride="+srcPixelStride);
						Console.WriteLine(e.ToString());
					}
				} else {
//					Console.WriteLine("x in src="+xInSrcCoord+",x in dest="+xInDestCoord+",dest width="+destWidth+",src width="+srcWidth);
					for (int c = 0; c < numChannels; c ++)
						destBuffer[xInDestCoord * destPixelStride + c] = (step + numSamplesInDestPixel) * destBuffer[xInDestCoord * destPixelStride + c] / numSamplesInDestPixel;
					// Src is out of buffer.
				}
				xInDestCoord += stepInDestCoord;
				if (stepInDestCoord > 0)
					numSamplesInDestPixel = 0;
				
				if (step < destWidth) {
					if (xInSrcCoord < origSrcWidth) {
						for (int c = 0; c < numChannels; c ++)
							destBuffer[xInDestCoord * destPixelStride + c] += (destWidth - step) * srcBuffer[srcOffset + c] * yStep;
					} else {
//						Console.WriteLine("X:clear destBufffer["+xInSrcCoord+"]");
						numSamplesInDestPixel += destWidth - step;
						// Src is out of buffer.
						for (int c = 0; c < numChannels; c ++)
							destBuffer[xInDestCoord * destPixelStride + c] = 0;
					}
				}
				srcOffset += srcPixelStride;
				xInSubSampledCoord += destWidth;
				xInSrcCoord  += 1;				
			}
		}
		
		private void ShrinkChannels(byte[] destBuffer,
		                            int destOffset, int destRowStride, int destPixelStride, 
		                            int destWidth, int destHeight,
		                            byte[] srcBuffer,
		                            int srcOffset, int srcRowStride, int srcPixelStride,  
		                            int origSrcWidth, int origSrcHeight,
		                            int numChannels, int srcScale, int destScale) {

			int[] intermediateBuffer = new int[destWidth * numChannels];
			int subsampledWidth = (int)((long)destWidth * destWidth * srcScale / destScale);
			int subsampledHeight = (int)((long)destHeight * destHeight * srcScale / destScale);
			int srcWidth = subsampledWidth / destWidth;
			subsampledWidth = srcWidth * destWidth; // re-calculation.
			int srcHeight = subsampledHeight / destHeight;
			subsampledHeight = srcHeight * destHeight; // re-calculation.
			int yInSubSampledCoord = 0;
			int yInSrcCoord = 0;
			int yInDestCoord = 0;
			int yOfNextGridInDestCoord = srcHeight;
			int accumulatedSamples = srcHeight * srcWidth;
			
//			Console.WriteLine("destWidth ="+destWidth+", destHeight ="+destHeight);
//			Console.WriteLine("srcWidth ="+srcWidth+", srcHeight ="+srcHeight);
			
			while (yInSubSampledCoord < subsampledHeight) {
				int step = destHeight;
				int stepInDestCoord = 0;
				
				if (yInSubSampledCoord + destHeight < yOfNextGridInDestCoord) {
					// pass

				} else if (yInSubSampledCoord + destHeight == yOfNextGridInDestCoord) {
					stepInDestCoord = 1;
					yOfNextGridInDestCoord += srcHeight;

				} else {
					step = yOfNextGridInDestCoord - yInSubSampledCoord;
					stepInDestCoord = 1;
					yOfNextGridInDestCoord += srcHeight;
				}

//					Console.WriteLine("dest="+yInDestCoord+",src="+yInSrcCoord+",subsampled="+yInSubSampledCoord+",srcOffset="+srcOffset+",srcRowStride="+srcRowStride);
				if (yInSrcCoord < origSrcHeight) {
					AccumulateShrinkedLine(intermediateBuffer, numChannels, destWidth,
					                       srcBuffer, srcOffset, srcPixelStride, origSrcWidth,
					                       numChannels, step);
				} else {
//					Console.WriteLine("y in src="+yInSrcCoord+",height="+srcHeight);
					accumulatedSamples -= srcHeight;
				}

				if (stepInDestCoord > 0) {
					if (accumulatedSamples > 0) {
						for (int i = 0; i < destWidth; i ++) {
							for (int c = 0; c < numChannels; c++)
								destBuffer[destOffset+c] = (byte)(intermediateBuffer[i * numChannels + c] / accumulatedSamples);
							destOffset += destPixelStride;
						}
					} else {
//						Console.WriteLine("clear destBuffer["+destOffset+"-"+(destOffset+destWidth*numChannels)+"]");
						Array.Clear(destBuffer, destOffset, destWidth * numChannels);
					}
					destOffset += destRowStride - destWidth * destPixelStride;
					Array.Clear(intermediateBuffer, 0, intermediateBuffer.Length);
					yInDestCoord += stepInDestCoord;
				}
				
				if (step < destHeight) {
					if (yInSrcCoord < origSrcHeight) {
						AccumulateShrinkedLine(intermediateBuffer, numChannels, destWidth,
						                       srcBuffer, srcOffset, srcPixelStride, origSrcWidth,
						                       numChannels, destHeight - step);
					} else if (stepInDestCoord == 0) { // When stepInDestCoord > 0, intermediateBuffer is 
						                               // already cleared.
//						Console.WriteLine("clear destBuffer["+destOffset+"-"+(destOffset+destWidth*numChannels)+"]");
						Array.Clear(intermediateBuffer, 0, intermediateBuffer.Length);
					} else {
//						Console.WriteLine("Do nothing");
						// pass
					}
				}
				yInSubSampledCoord += destHeight;
				srcOffset += srcRowStride;
				yInSrcCoord  += 1;
			}
		}
		
		
		private void FillExpandedLine(byte[] destBuffer,
				                            int destPixelStride, int destWidth,
				                            byte[] srcBuffer,
				                            int srcOffset, int srcPixelStride,  
		                                    int origSrcWidth,
				                            int numChannels) {
			int subsampledWidth = (int)((long)destWidth * destWidth * srcScale / destScale);
			int srcWidth = subsampledWidth / destWidth;
			subsampledWidth = srcWidth * destWidth; // re-calculation.
			int xInSubSampledCoord = 0;
			int xInSrcCoord = 0;
			int xInDestCoord = 0;
			int xOfNextGridInSrcCoord = destWidth;
			int destOffset = 0;

			while (xInSubSampledCoord < subsampledWidth) {
				int step = srcWidth;
				int stepInSrcCoord = 0;
				
				if (xInSubSampledCoord + srcWidth < xOfNextGridInSrcCoord) {
					// pass

				} else if (xInSubSampledCoord + srcWidth == xOfNextGridInSrcCoord) {
					stepInSrcCoord = 1;
					xOfNextGridInSrcCoord += destWidth;

				} else {
					step = xOfNextGridInSrcCoord - xInSubSampledCoord;
					stepInSrcCoord = 1;
					xOfNextGridInSrcCoord += destWidth;
				}
				
				if (xInSrcCoord < origSrcWidth) {
					for (int c = 0; c < numChannels; c ++)
						destBuffer[destOffset + c] = srcBuffer[srcOffset+c];
				} else {
					// Src is out of buffer.
//					Console.WriteLine("x in src="+xInSrcCoord+",x in dest="+xInDestCoord+",dest width="+destWidth+",src width="+srcWidth);
					for (int c = 0; c < numChannels; c ++)
						destBuffer[destOffset + c] = 0;
				}

				if (stepInSrcCoord > 0) {
					xInSrcCoord += stepInSrcCoord;
					srcOffset += stepInSrcCoord * srcPixelStride;
				}
				
				if (step < srcWidth) {
					if (xInSrcCoord < origSrcWidth) {
						for (int c = 0; c < numChannels; c ++)
							destBuffer[destOffset + c] = (byte)( (step * (int)destBuffer[destOffset+c] + (srcWidth - step) * (int)srcBuffer[srcOffset + c]) / srcWidth );
					} else {
						// Src is out of buffer.
						for (int c = 0; c < numChannels; c ++)
							destBuffer[destOffset + c] = 0;
					}
				}
				destOffset += destPixelStride;
				xInSubSampledCoord += srcWidth;
				xInDestCoord  += 1;				
			}
		}
		
		private void ExpandChannels(byte[] destBuffer,
		                            int destOffset, int destRowStride, int destPixelStride, 
		                            int destWidth, int destHeight,
		                            byte[] srcBuffer,
		                            int srcOffset, int srcRowStride, int srcPixelStride,  
		                            int origSrcWidth, int origSrcHeight,
		                            int numChannels, int srcScale, int destScale) {

			byte[] intermediateBuffer = new byte[destWidth * numChannels];
			byte[] filledIntermediateBuffer = null;
			int subsampledWidth = (int)((long)destWidth * destWidth * srcScale / destScale);
			int subsampledHeight = (int)((long)destHeight * destHeight * srcScale / destScale);
			int srcWidth = subsampledWidth / destWidth;
			subsampledWidth = srcWidth * destWidth; // re-calculation.
			int srcHeight = subsampledHeight / destHeight;
			subsampledHeight = srcHeight * destHeight; // re-calculation.
			int yInSubSampledCoord = 0;
			int yInSrcCoord = 0;
			int yInDestCoord = 0;
			int yOfNextGridInSrcCoord = destHeight;
			
//			Console.WriteLine("destWidth ="+destWidth+", destHeight ="+destHeight);
//			Console.WriteLine("srcWidth ="+srcWidth+", srcHeight ="+srcHeight);
			
			while (yInSubSampledCoord < subsampledHeight) {
				int step = srcHeight;
				int stepInSrcCoord = 0;
				
				if (yInSubSampledCoord + srcHeight < yOfNextGridInSrcCoord) {
					// pass

				} else if (yInSubSampledCoord + srcHeight == yOfNextGridInSrcCoord) {
					stepInSrcCoord = 1;
					yOfNextGridInSrcCoord += destHeight;

				} else {
					step = yOfNextGridInSrcCoord - yInSubSampledCoord;
					stepInSrcCoord = 1;
					yOfNextGridInSrcCoord += destHeight;
				}

				// fill in intermediate buffer lines.
				if (filledIntermediateBuffer == null) {
					filledIntermediateBuffer = intermediateBuffer;
					if (yInSrcCoord < origSrcHeight) {
						FillExpandedLine(filledIntermediateBuffer, destPixelStride, destWidth, srcBuffer, srcOffset, srcPixelStride, origSrcWidth, numChannels);
					} else {
//						Console.WriteLine("y in src="+yInSrcCoord+",height="+srcHeight);
						Array.Clear(filledIntermediateBuffer, 0, filledIntermediateBuffer.Length);
					}
				}
				
				// fill in destination buffer lines.
				Array.Copy(filledIntermediateBuffer, 0, destBuffer, destOffset, destWidth * numChannels);

				if (stepInSrcCoord > 0) {
					srcOffset += srcRowStride;
					yInSrcCoord += stepInSrcCoord;
					filledIntermediateBuffer = null;
				}

				// blend destination buffer lines with new intermediate buffer line.
				if (step < srcHeight) {
					filledIntermediateBuffer = intermediateBuffer;
					if (yInSrcCoord < origSrcHeight) {
						FillExpandedLine(filledIntermediateBuffer, destPixelStride, destWidth, srcBuffer, srcOffset, srcPixelStride, origSrcWidth, numChannels);
					} else {
						Array.Clear(filledIntermediateBuffer, 0, filledIntermediateBuffer.Length);
					}
					// blend here.
					for (int c = 0; c < destWidth * numChannels; c ++)
						destBuffer[destOffset + c] = (byte)( (step * (int)destBuffer[destOffset+c] + (srcHeight - step) * (int)filledIntermediateBuffer[c]) / srcHeight );
				}

				yInSubSampledCoord += srcHeight;
				destOffset += destRowStride;
				yInDestCoord  += 1;
			}
		}
#endif
		
		/*
		 * ApplySubSample: 
		 *  This operation is under construction. currently only available for 
		 * 1. GenericSurface.
		 *  (Unfortunately not for TiledSurfaces.)
		 * 2. Shrink and copy operation.
		 *  (Not for expand operation.)
		 */
		public void ApplySubSample(ISurfaceIterator surfIter, ISurfaceIterator destIter,
		                    int destWidth, int destHeight) {
			try {
				try {
				D.StopWatches.SubsampleOperation_ApplySubsample.Start();
				} catch (Exception e) {
					Console.WriteLine(e);
				}

			bool surfHasColor = surfIter.Raster.HasColorChannels;
			bool destHasColor = destIter.Raster.HasColorChannels;

			int surfChannels = surfIter.Raster.NumChannels;
			int destChannels = destIter.Raster.NumChannels;

			if (surfChannels != destChannels) {
				// TBD.
				Console.WriteLine("src channels != dest channels, not yet implemented.");
				return;
			}

			if (!surfHasColor && destHasColor) {
				// TBD.
				Console.WriteLine("src does not have color , not yet implemented.");
				return;
			}
			
			if (srcScale < destScale) {
				// Expanding. TBD.
//				Console.WriteLine("Expand: Not yet implemented.");
#if USE_EXTERNAL_OPS
			CExpand(
#else
			ExpandChannels(
#endif
				               destIter.Raster.Buffer, destIter.OffsetInBuffer, 
				               destIter.Raster.RowStride, destIter.Raster.PixelStride,
				               destWidth, destHeight,
				               surfIter.Raster.Buffer, surfIter.OffsetInBuffer,
				               surfIter.Raster.RowStride, surfIter.Raster.PixelStride,
				               surfIter.WidthOfRaster, surfIter.HeightOfRaster,
				               destChannels, srcScale, destScale);
			} else if (srcScale > destScale) {
				// Shrink.
#if USE_EXTERNAL_OPS
			CShrink(
#else
			ShrinkChannels(
#endif
					       destIter.Raster.Buffer, destIter.OffsetInBuffer, 
				           destIter.Raster.RowStride, destIter.Raster.PixelStride,
				           destWidth, destHeight,
				           surfIter.Raster.Buffer, surfIter.OffsetInBuffer,
				           surfIter.Raster.RowStride, surfIter.Raster.PixelStride,
				           surfIter.WidthOfRaster, surfIter.HeightOfRaster,
				           destChannels, srcScale, destScale);
			} else {
				// Copy. TBD.
				CopyChannels(destIter.Raster.Buffer, destIter.OffsetInBuffer, 
				               destIter.Raster.RowStride, destIter.Raster.PixelStride,
				               destWidth, destHeight,
				               surfIter.Raster.Buffer, surfIter.OffsetInBuffer,
				               surfIter.Raster.RowStride, surfIter.Raster.PixelStride,
				               surfIter.WidthOfRaster, surfIter.HeightOfRaster,
				               destChannels);
			}
			} finally {
				D.StopWatches.SubsampleOperation_ApplySubsample.Stop();
			}
						
		}
		
	}
}