// /home/tarai/Projects/gsaw/StopWatches.cs created with MonoDevelop
// User: tarai at 18:30 2008/05/25
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Collections;

namespace D { // Debug 
	
	public class StopWatches {
		
		public static StopWatch CompositeOperation_Apply;
		public static StopWatch BlendOperation_Apply;
		public static StopWatch BrushTool_OnUpdateStroke;
		public static StopWatch Image_UpdateProjection;
		public static StopWatch Viewport_OnUpdateImage;
		public static StopWatch Viewport_OnUpdateScaledView;
		public static StopWatch BrushTool_PaintDab;
		public static StopWatch BrushTool_CreateDab;
		public static StopWatch SubsampleOperation_ApplySubsample;
		public static StopWatch RotateOperation_Apply;
		
		public static ArrayList watches;
		
		public class Item {
			public StopWatch watch;
			public string name;	
			public Item(StopWatch w, string n) {
				watch = w;
				name = n;
			}
		};
		
		public static void Initialize(){
			watches = new ArrayList();
			watches.Add(new Item(CompositeOperation_Apply = new StopWatch(), "CompositeOperation.Apply"));
			watches.Add(new Item(BlendOperation_Apply = new StopWatch(), " BlendOperation.Apply"));
			watches.Add(new Item(SubsampleOperation_ApplySubsample = new StopWatch(), "SubsampleOperation.ApplySubsample"));
			watches.Add(new Item(RotateOperation_Apply = new StopWatch(), "RotateOperation.Apply"));
			watches.Add(new Item(BrushTool_OnUpdateStroke = new StopWatch(), "BrushTool.OnUpdateStroke"));
			watches.Add(new Item(BrushTool_PaintDab = new StopWatch(), " BrushTool.PaintDab"));
			watches.Add(new Item(BrushTool_CreateDab = new StopWatch(), "  BrushTool.CreateDab"));
			watches.Add(new Item(Image_UpdateProjection = new StopWatch(), " Image.UpdateProjection"));
			watches.Add(new Item(Viewport_OnUpdateImage = new StopWatch(), "  Viewport.OnUpdateImageArea"));
			watches.Add(new Item(Viewport_OnUpdateScaledView = new StopWatch(), "   Viewport.OnUpdateScaledView"));
		}
		
		public static void DumpAndReset() {
			foreach (Item i in watches) {
				Console.WriteLine("{0},{1},{2}", i.name, i.watch.TotalTime, i.watch.StartCount);
			}
			
			foreach (Item i in watches) {
				i.watch.Reset();
			}
		}

	}
}
