// /home/tarai/Projects/gsaw/gsaw/NearestNeighborRescaleOperator.cs created with MonoDevelop
// User: tarai at 0:08 2008/05/14
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Runtime.InteropServices;

namespace Holo.Operation {
	using Holo.Image;
	
	public class NearestNeighborRescaleOperator : TransformOperation {
		
		public NearestNeighborRescaleOperator() {
			this.Operator = ApplyRescale;
		}
		

		/*
		 * ApplyRescale: 
		 *  This operation is under construction. currently only available for 
		 * 1. GenericSurface.
		 *  (Unfortunately not for TiledSurfaces.)
		 * 2. Shrink and copy operation.
		 *  (Not for expand operation.)
		 */
		public void ApplyRescale(ISurfaceIterator surfIter, ISurfaceIterator destIter,
		                    int destWidth, int destHeight) {

			int prevY = 0;			
			for (int y = 0; !destIter.IsYEnded(); y ++) {
				int prevX = 0;
				int srcX = 0;
				int srcY = y * srcScale / destScale;
				if (srcY > prevY)
					surfIter.AddY(srcY - prevY);
				for (int x = 0; !destIter.IsXEnded(); x ++) {
					srcX = x * srcScale / destScale;
					if (srcX > prevX)
						surfIter.AddX(srcX - prevX);
					int surfAlpha;
					if (surfIter.Raster.HasAlpha)
						surfAlpha = surfIter.Raster.Buffer[surfIter.OffsetInBuffer + destIter.Raster.NumChannels - 1];
					else
						surfAlpha = surfIter.Raster.PrimaryAlphaValue[0];
					byte[] colors = null;
					int offset = 0;
					byte[] dest = destIter.Raster.Buffer;
					int destOffset = destIter.OffsetInBuffer;
					if (surfIter.Raster.HasColorChannels) {
						colors = surfIter.Raster.Buffer;
						offset = surfIter.OffsetInBuffer;
					} else {
						colors = surfIter.Raster.PrimaryColor;
						offset = 0;
					}
					if (destIter.Raster.HasAlpha) {
						for (int c = 0; c < destIter.Raster.NumChannels - 1; c++)
							dest[destOffset + c] = colors[offset + c];
						dest[destOffset+destIter.Raster.NumChannels - 1] = (byte)surfAlpha;
					} else {
						for (int c = 0; c < destIter.Raster.NumChannels; c++)
							dest[destOffset + c] = (byte)(colors[offset + c] * surfAlpha / 255);
					}
					prevX = srcX;
					destIter.AddX(1);
				}
				prevY = srcY;
				surfIter.AddX(-srcX);
				destIter.ResetXAndAddY(1);
			}
		}
		
	}
}