// /home/tarai/Projects/gsaw/gsaw/MultipleSurfaceIterator.cs created with MonoDevelop
// User: tarai at 20:51 2008/04/27
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;

namespace Holo.Image {
	
	
	public class MultipleSurfaceIterator {
		private int minX;
		private int minY;
		private int maxX;
		private int maxY;
		private int currentWidth;
		private int currentHeight;
		private int offsetX;
		private int offsetY;
		private ISurfaceIterator[] iterators;
		
		public MultipleSurfaceIterator(ISurfaceIterator[] iterators, int minX, int minY, int maxX, int maxY) {
			Initialize(iterators, minX, minY, maxX, maxY);
		}
				
		private void Initialize(ISurfaceIterator[] iterators, int minX, int minY, int maxX, int maxY) {
			this.iterators = (ISurfaceIterator[])iterators.Clone();
			offsetX = 0;
			offsetY = 0;
			SetRange(minX, minY, maxX, maxY);
		}
		
		public void SetRange(int minX, int minY, int maxX, int maxY) {
			this.minX = minX;
			this.minY = minY;
			this.maxX = maxX;
			this.maxY = maxY;
			foreach(ISurfaceIterator iter in iterators) {
				iter.SetRange(minX, minY, maxX, maxY);
			}
			if (offsetX < minX)
				offsetX = minX;
			if (offsetY < minY)
				offsetY = minY;
			CalcSize();
		}
		
		public int WidthOfRaster {
			get { return currentWidth; }
		}
		public int HeightOfRaster {
			get { return currentHeight; }
		}
		public void AddX(int x) {
			offsetX += x;
			currentWidth = maxX - offsetX;
//			Console.WriteLine("AddX");
			foreach (ISurfaceIterator iter in iterators) {
				iter.AddX(x);
//				Console.WriteLine("Compare:width at"+offsetX+","+offsetY+":current="+currentWidth+",iter="+iter.WidthOfRaster+"/Type="+iter.GetType().ToString());
				if (iter.WidthOfRaster < currentWidth)
					currentWidth = iter.WidthOfRaster;
			}
		}

		public void AddY(int y) {
			offsetY += y;
			currentHeight = maxY - offsetY;
//			Console.WriteLine("AddY");
			foreach (ISurfaceIterator iter in iterators) {
				iter.AddY(y);
//				Console.WriteLine("Compare:height at"+offsetX+","+offsetY+":current="+currentHeight+",iter="+iter.HeightOfRaster+"/Type="+iter.GetType().ToString());
				if (iter.HeightOfRaster < currentHeight)
					currentHeight = iter.HeightOfRaster;
			}
		}

		public void ResetXAndAddY(int y) {
			offsetX = minX;
			offsetY += y;
			currentWidth = maxX - offsetX;
			currentHeight = maxY - offsetY;
//			Console.WriteLine("ResetXAndAddY");
			foreach (ISurfaceIterator iter in iterators) {
				iter.ResetXAndAddY(y);
//				Console.WriteLine("Compare:width at"+offsetX+","+offsetY+":current="+currentWidth+",iter="+iter.WidthOfRaster+"/Type="+iter.GetType().ToString());
//				Console.WriteLine("Compare:height at"+offsetX+","+offsetY+":current="+currentHeight+",iter="+iter.HeightOfRaster+"/Type="+iter.GetType().ToString());
				if (iter.WidthOfRaster < currentWidth)
					currentWidth = iter.WidthOfRaster;
				if (iter.HeightOfRaster < currentHeight)
					currentHeight = iter.HeightOfRaster;
			}
		}

		private void CalcSize() {
			currentWidth = maxX - offsetX;
			currentHeight = maxY - offsetY;
			foreach (ISurfaceIterator iter in iterators) {
				if (iter.WidthOfRaster < currentWidth)
					currentWidth = iter.WidthOfRaster;
				if (iter.HeightOfRaster < currentHeight)
					currentHeight = iter.HeightOfRaster;
			}
		}

		public bool IsXEnded() {
			return offsetX >= maxX;
		}
		
		public bool IsXBelowMin() {
			return offsetX < minX;
		}

		public bool IsYEnded() {
			return offsetY >= maxY;			
		}
		
		public bool IsYBelowMin() {
			return offsetY < minY;
		}
	}
}
