// /home/tarai/Projects/gsaw/MonochromeRasterFactory.cs created with MonoDevelop
// User: tarai at 19:46 2008/05/06
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;


namespace Holo.Image.Generic {
	using Holo.Image;
	
	public class MonochromeRasterFactory : IRasterFactory {
		private byte[] primaryColor;
		
		public MonochromeRasterFactory(byte[] primaryColor) {
			this.primaryColor = (byte[])primaryColor.Clone();
		}
		
		public IRaster CreateNewRaster(int width, int height) {
			return new MonochromeRaster(width, height, primaryColor);
		}
		
		public IRaster CreateCopyOfRaster(IRaster src) {
			return new MonochromeRaster(src, primaryColor);
		}
	}
}
