// /home/tarai/Projects/gsaw/MonochromeRaster.cs created with MonoDevelop
// User: tarai at 19:23 2008/05/06
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using Gdk;

namespace Holo.Image.Generic
{
	using Holo.Image;
	
	public class MonochromeRaster : IRaster
	{
		private const int NUM_CHANNELS = 1;
		private const int DEFAULT_BIT_DEPTH = 8;
		
		private int width;
		private int height;
		private int pixelStride;
		private int rowStride;
		private int bitsPerPixel;
		private bool mustBeCopiedOnWrite;
		
		private byte[] buffer;
		private byte[] primaryColor;

		public MonochromeRaster() {
			byte[] color = { 255, 255, 255 };
			Initialize(0, 0, color);
		}
		
		public MonochromeRaster(int width, int height, byte[] primaryColor) {
			Initialize(width, height, primaryColor);
		}
		
		public MonochromeRaster(IRaster src, byte[] primaryColor) {
			Initialize(src.Width, src.Height, primaryColor);

			// Copy from src buffer
			bool srcHasAlpha = src.HasAlpha;
			int  srcRowStride = src.RowStride;
			int  srcPixelStride = src.PixelStride;
			int  srcNumChannels = src.NumChannels;
			byte   srcAlpha = 0;
			
			if (!srcHasAlpha)
				srcAlpha = src.PrimaryAlphaValue[0];
			else {
				for (int y = 0; y < height; y ++) {
					for (int x = 0; x < width; x ++) {
						srcAlpha = src.Buffer[y * srcRowStride + x * srcPixelStride + srcNumChannels - 1];
						buffer[y * rowStride + x * pixelStride] = srcAlpha;
					}
				}
			}
		}
		
		private void Initialize(int width, int height, byte[] primaryColor) {
			this.width = (width != 0)? width : 1;
			this.height = (height != 0)? height : 1;
			this.primaryColor = primaryColor;
			bitsPerPixel = DEFAULT_BIT_DEPTH >> 3;
			pixelStride = bitsPerPixel;
			rowStride = pixelStride * width;
			buffer = new byte[rowStride * height];
			mustBeCopiedOnWrite = false;
		}
		
		public int Width {
			get { return width; }
		}
		public int Height {
			get { return height; }
		}
		
		public int BitsPerPixel {
			get { return bitsPerPixel; }
		}
		
		public int PixelStride {
			get { return pixelStride; }
		}

		public int RowStride {
			get { return rowStride; }
		}
		
		public string Format {
			get { return "A"; }
		}
		
		public int NumChannels {
			get { return 1; }
		}
		
		public byte[] Buffer {
			get { return buffer; }
		}
		
		public bool HasAlpha {
			get { return true; }
		}
		
		public bool HasColorChannels { 
			get { return false; } 
		}
		
		public byte[] PrimaryAlphaValue { 
			get { 
				byte[] result = { 255 };
				return result; 
			}
		}
		
		public byte[] PrimaryColor { 
			get { return primaryColor; }
			set { primaryColor = value; }
		}
		
		public bool MustBeCopiedOnWrite {
			get {
				return mustBeCopiedOnWrite;
			}
			set {
				mustBeCopiedOnWrite = value;
			}
		}
	}
}
