// /home/tarai/Projects/gsaw/gsaw/JobProcessor2.cs created with MonoDevelop
// User: tarai at 2:50 2008/05/25
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using System.Threading;
using System.Collections;

namespace Holo.Operation.Processor {

	public class JobProcessor2 : JobProcessor {
		private ArrayList jobs;
		private Queue availableJobs;
		private int waitingJobs;
		private int workAmount;

		
		public JobProcessor2() {
			jobs = new ArrayList();
			availableJobs = new Queue();
			workAmount = 0;
		}

		
		public void Add(CompositeJob newJob) {
			jobs.Add(newJob);
			workAmount += newJob.Amount;
		}
		
		private void OnAvailable(CompositeJob job) {
			ThreadPool.QueueUserWorkItem(job.RunInThread, 0);
		}
		
		private void OnFinish(CompositeJob job) {
			lock (this) {
				waitingJobs --;
				if (waitingJobs == 0)
					Monitor.Pulse(this);
			}
		}
		
		public void ProcessSync() {			
			waitingJobs = jobs.Count;
			
			if (waitingJobs == 0)
				return;
			
			if (workAmount < 4 * 64 * 64 * 4) {
				foreach (CompositeJob job in jobs) {
					job.Run(0);
				}
			} else {
				lock (this) {
					for (int i = 0; i < jobs.Count; i ++) {
						CompositeJob newJob = (CompositeJob)jobs[i];
						for (int j = 0; j < i; j ++) {
							newJob.ConstructDependencyChain((CompositeJob)jobs[j]);
						}
						if (newJob.Available) {
							availableJobs.Enqueue(newJob);
						} else
							newJob.OnAvailable = this.OnAvailable;
						newJob.OnFinishJob += OnFinish;
					}
					
					foreach (CompositeJob job in availableJobs) {
						ThreadPool.QueueUserWorkItem(job.RunInThread, 0);
					}
				
					Monitor.Wait(this);
				}
			}

			availableJobs.Clear();
			jobs.Clear();
			workAmount = 0;
		}
		
	}
}