// /home/tarai/Projects/gsaw/gsaw/RGBARaster.cs created with MonoDevelop
// User: tarai at 16:48 2008/04/27
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;
using Gdk;

namespace Holo.Image.Generic
{
	using Holo.Image;
	
	public class GenericRaster : IRaster
	{
		private const int DEFAULT_WIDTH = 64;
		private const int DEFAULT_HEIGHT = 64;
		private const int NUM_CHANNELS = 3;
		private const int DEFAULT_BIT_DEPTH = 8;
		
		private int width;
		private int height;
		private int pixelStride;
		private int rowStride;
		private int bitsPerPixel;
		private int numChannels;
		private bool hasAlpha;
		private bool mustBeCopiedOnWrite;
		
		private byte[] buffer;

		public GenericRaster() {
			Initialize(0, 0, false);
		}
		
		public GenericRaster(int width, int height, bool hasAlpha) {
			Initialize(width, height, hasAlpha);
		}
		
		public GenericRaster(IRaster src, bool hasAlpha) {
			// Copy from src buffer
			bool srcHasAlpha = src.HasAlpha;
			bool srcHasColorChannels = src.HasColorChannels;
			if (hasAlpha == srcHasAlpha && srcHasColorChannels) {
				buffer = (byte[])src.Buffer.Clone();
				Initialize(src.Width, src.Height, hasAlpha);
				return;
			}
			int  srcRowStride = src.RowStride;
			int  srcPixelStride = src.PixelStride;
			int  srcNumChannels = src.NumChannels;
			Initialize(src.Width, src.Height, hasAlpha);

			int  numColorChannels = this.hasAlpha? numChannels - 1: numChannels;
			byte[] srcPrimaryColor = null;
			byte   srcAlpha = 0;
			if (!srcHasColorChannels)
				srcPrimaryColor = src.PrimaryColor;
			else
				srcPrimaryColor = new byte[pixelStride];
			
			if (!srcHasAlpha)
				srcAlpha = src.PrimaryAlphaValue[0];

			for (int y = 0; y < height; y ++) {
				for (int x = 0; x < width; x ++) {
					if (srcHasColorChannels) {
						Array.Copy(src.Buffer, y * srcRowStride + x * srcPixelStride, srcPrimaryColor, 0, numColorChannels);
					}
					Array.Copy(srcPrimaryColor, 0, buffer, y * rowStride + x * pixelStride, numColorChannels);
					if (srcHasAlpha)
						srcAlpha = src.Buffer[y * srcRowStride + x * srcPixelStride + srcNumChannels - 1];
					if (hasAlpha)
						buffer[y * rowStride + x * pixelStride + numColorChannels] = srcAlpha;
				}
			}
		}
		
		private void Initialize(int width, int height, bool hasAlpha) {
			this.width = (width != 0)? width : DEFAULT_WIDTH;
			this.height = (height != 0)? height : DEFAULT_HEIGHT;
			bitsPerPixel = DEFAULT_BIT_DEPTH >> 3;
			numChannels = NUM_CHANNELS + ((hasAlpha)? 1: 0);
			pixelStride = bitsPerPixel * numChannels;
			rowStride = pixelStride * width;
			if (buffer == null)
				buffer = new byte[rowStride * height];
			this.hasAlpha = hasAlpha;
			mustBeCopiedOnWrite = false;
		}
		
		public int Width {
			get { return width; }
		}
		public int Height {
			get { return height; }
		}
		
		public int BitsPerPixel {
			get { return bitsPerPixel; }
		}
		
		public int PixelStride {
			get { return pixelStride; }
		}

		public int RowStride {
			get { return rowStride; }
		}
		
		public string Format {
			get { return (numChannels == NUM_CHANNELS)? "CCC": "CCCA"; }
		}
		
		public int NumChannels {
			get { return numChannels; }
		}
		
		public byte[] Buffer {
			get { return buffer; }
		}
		
		public bool HasAlpha {
			get { return hasAlpha; }
		}
		
		public bool HasColorChannels { 
			get { return true; } 
		}
		
		public byte[] PrimaryAlphaValue { 
			get { 
				byte[] result = { 255 };
				return result; 
			}
		}
		
		public byte[] PrimaryColor { 
			get {
				byte[] result = { 255, 255, 255 };
				return result;
			}
		}
		
		public bool MustBeCopiedOnWrite {
			get {
				return mustBeCopiedOnWrite;
			}
			set {
				mustBeCopiedOnWrite = value;
			}
		}
	}
}
