// /home/tarai/Projects/gsaw/CompactGenericRasterFactory.cs created with MonoDevelop
// User: tarai at 21:41 2008/05/18
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//

using System;


namespace Holo.Image.Generic {
	using Holo.Image;
	
	public class CompactGenericRasterFactory : IRasterFactory {
		private byte[] primaryColor;
		private byte[] alpha;
		private bool hasAlpha;
		
		public CompactGenericRasterFactory(byte[] primaryColor, byte[] alpha, bool hasAlpha) {
			this.primaryColor = (byte[])primaryColor.Clone();
			this.alpha = (byte[])alpha.Clone();
			this.hasAlpha = hasAlpha;
		}
		
		public IRaster CreateNewRaster(int width, int height) {
			return new ColoredRaster(width, height, primaryColor, alpha);
		}
		
		public IRaster CreateCopyOfRaster(IRaster src) {
			return new GenericRaster(src, hasAlpha);
		}
	}
}
