#pragma once
#include <QtCore>
namespace structures{
    class header{
    public:
        header();
        header(const QString &senderName,const QFileInfo &fileinfo);
        header(const QString &senderName,const QByteArray &msg);
        QString fileName()const,
        senderName()const;
        quint64 datasize()const;
        QVector<quint32> ripemd160() const;
        bool operator==(const header &) const;
        bool operator!=(const header &) const;
        void operator=(const header &);
        friend QDataStream &operator<<(QDataStream &out,const header &value){
            out<<value.data_size<<value.rmd6_hash<<value.sendername<<value.filename;
            return out;
        }
        friend QDataStream &operator>>(QDataStream &in,header &value){
            in>>value.data_size>>value.rmd6_hash>>value.sendername>>value.filename;
            return in;
        }

        void senderName(const QString &),
        datasize(const quint64),
        fileName(const QString &);

    private:
        QString filename,sendername;
        quint64 data_size;
        QVector<quint32> rmd6_hash;
    };
}
