#include<iostream>
#include"basis.h"
using namespace std;
using namespace enc_hash::inside;
quint32 hash_basis::left_rol(const quint32 &x,const quint32 &n)const{return ((x<<n)|(x>>(32-n)));}
QVector<quint32> hash_basis::__compute_hash(context_basis &context,const QByteArray &str){
	const quint32 *msg=(const quint32 *)str.data();
	context.len[0]=str.size();
	for(quint32 size=str.size();size>63;size-=64,msg+=16){
		memcpy(context.X,msg,sizeof(context.X));
		this->compress(context);
	}
	this->finish(context,msg);
	return context.buf;
}
QVector<quint32> hash_basis::__compute_hash(context_basis &context,QIODevice &stream){
	if((!stream.isOpen()&&!stream.open(QIODevice::ReadOnly))||!stream.isReadable())
		return QVector<quint32>(5);
	quint32 index,pos=stream.pos();
	QByteArray data;
	while(!stream.atEnd()){
		data=stream.read(0x100);
		for(quint32 i=0;i<(data.size()>>6);i++){
			memcpy(context.X,((quint32*)data.data())+(16*i),sizeof(context.X));
			this->compress(context);
		}
		if(context.len[0]+data.size()<context.len[0]) context.len[1]++;
		context.len[0]+=data.size();
	}
	//Take modulo 64*15
	index=(context.len[0]&0x3c0)>>2;

	this->finish(context,((quint32*)data.data())+index);
	stream.seek(pos);
	return context.buf;
}
void hash_basis::finish(context_basis &context,const quint32 *str){
	memset(context.X,0,sizeof(context.X));
	quint32 len64=context.len[0]&63;
	memcpy(context.X,str,len64);
	context.X[(context.len[0]>>2)&15]^=(uint)1<<(8*(context.len[0]&3)+7);
	if(len64>55){
		this->compress(context);
		memset(context.X,0,sizeof(context.X));
	}
	context.X[14]=context.len[0]<<3;
	context.X[15]=(context.len[0]>>29)|(context.len[1]<<3);
	this->compress(context);
}
