#pragma once
#include <QtNetwork>
#include "../definition.h"
#include "../structures/header.h"
#include "../definition.h"
#include "../ported_rmd6/rmd6.h"

#define default_bandwidth 0x400
namespace network{
	class tcpSocket;

	class tcpServer:virtual public QTcpServer{
		Q_OBJECT
	public:
		tcpServer(quint64 buffersize=default_bandwidth,QObject *parent=NULL);
	signals:
		bool pending(const tcpSocket &) const;
		void socket_error(const tcpSocket &) const;
	protected:
		void incomingConnection(int handle);
	private:
		quint64 buffersize;
	};

	class tcpSocket:public QTcpSocket{
		Q_OBJECT
	public:
		//This constructor is for server. it works as a session.
		tcpSocket(quint64 buffersize=default_bandwidth,QObject *parent=NULL);
		//This constructor is for client. it works as a client.
		tcpSocket(const QString &senderName,quint64 buffersize=default_buffer_size,QObject *parent=NULL);
		QString path_to_save() const;
		structures::header header_data() const;
		//Calling operator<<(QFile), the specified file stream will be copied.
		tcpSocket &operator<<(const QString &),
				  &operator<<(QFile &);
	signals:
		QString file_pending() const;
		QString fileStream_openFailed(const QFile::FileError &,const QString &) const;

		void msg_received(const QString &) const;

		void file_receive_progress(const quint64 streamPos) const;
		void file_saved() const;

		void sentData();
		void file_header_sent();
		void sending_file_progress(const quint64 pos);
	private slots:
		void read_data();
		void cancel();
	protected:
		void disconnectFromHostImplementation();
	private:
		enum mode{headsize,header_receive,data} event;
		void size_event();
		void header_event();
		void data_event();
		bool check_canceled_then_abort();
		//The size of header needs to be larger than 0, and smaller than or equal to 0xFFFF.
		quint16 header_size,buffer_size,timeout_time;
		structures::header head_data;
		bool canceled;
		QString where_to_save;
		QString senderName;
	};
}
