#include "tcpnetwork.h"
#include <cstring>
#include "../structures/header.h"

using namespace network;
using namespace enc_hash;
using namespace structures;
using namespace std;
tcpServer::tcpServer(quint64 buffersize, QObject *parent):QTcpServer(parent){this->buffersize=buffersize;}
void tcpServer::incomingConnection(int handle){
	tcpSocket *socket=new tcpSocket(this->buffersize,this);

	if(!socket->setSocketDescriptor(handle)){
		emit this->socket_error(*socket);
		delete socket;
		return;
	}
	emit (emit this->pending(*socket))?this->newConnection():socket->abort();
}

tcpSocket::tcpSocket(quint64 buffersize, QObject *parent):QTcpSocket(parent){
	this->buffer_size=buffersize;
	this->canceled=false;
	this->event=tcpSocket::headsize;
	connect(this,SIGNAL(disconnected()),SLOT(deleteLater()));
	connect(this,SIGNAL(readyRead()),SLOT(read_data()));
}
tcpSocket::tcpSocket(const QString &senderName,quint64 buffersize,QObject *parent):QTcpSocket(parent){
	this->buffer_size=buffersize;
	this->senderName=senderName;
}
void tcpSocket::read_data(){
	while(this->bytesAvailable()>0){
#ifdef DEBUG
		qDebug()<<"Server Event Mode:"<<this->event<<"Server Available bytes:"<<this->bytesAvailable();
#endif
		switch(this->event){
		case tcpSocket::headsize:		 this->size_event();		break;
		case tcpSocket::header_receive:  this->header_event();		break;
		case tcpSocket::data:			 this->data_event();		break;
		}
	}
}
void tcpSocket::size_event(){
	if(this->bytesAvailable()<2) return;
	char size_buf[2];
	this->read(size_buf,sizeof(size_buf));
	memcpy(&this->header_size,size_buf,
		   (sizeof(quint16)>sizeof(__typeof__(size_buf)))?sizeof(quint16):sizeof(size_buf)
		   );
	this->event=tcpSocket::header_receive;
}
void tcpSocket::header_event(){
	if(this->bytesAvailable()<this->header_size) return;
	else{
		QByteArray data=this->read(this->header_size);
		QDataStream datastream(data);
		datastream>>this->head_data;
		if(this->head_data==structures::header()){
			this->setErrorString(tr("The header is empty."));
			emit this->error(QAbstractSocket::UnknownSocketError);
			this->disconnectFromHost();
			return;
		}
		if(!this->head_data.fileName().isEmpty()){
			this->where_to_save=(emit this->file_pending());
			if(this->where_to_save.isEmpty()){
				this->write(QByteArray(1,0x00));

				this->setErrorString(tr("The filename is empty."));
				emit this->error(QAbstractSocket::UnknownSocketError);

				this->disconnectFromHost();
				return;
			}
		}
	}
	this->event=tcpSocket::data;
}
void tcpSocket::data_event(){
	if((quint64)this->bytesAvailable()<this->header_data().datasize()) return;

	quint64 final_readsize=this->head_data.datasize()%this->buffer_size,
	read_count=(this->head_data.datasize()-final_readsize)/this->buffer_size;

	if(this->head_data.fileName().isEmpty()){
		QByteArray msg;
		for(quint64 count=0;count<read_count;count++){
			if(this->check_canceled_then_abort())return;
			msg+=this->read(this->buffer_size);
		}
		if(this->check_canceled_then_abort())return;
		msg+=this->read(final_readsize);

		rmd6 generator;
		if(this->head_data.ripemd160()==generator.compute_hash(msg))
			emit this->msg_received(QString::fromUtf8(msg.data()));
		else{
			this->setErrorString(tr("The data has been broken."));
			emit this->error(QAbstractSocket::UnknownSocketError);
			this->disconnectFromHost();
		}
	}else{
		streamopen:
		if(this->where_to_save.isEmpty()){
			this->setErrorString(tr("The filename is empty."));
			emit this->error(QAbstractSocket::UnknownSocketError);
			this->disconnectFromHost();
			return;
		}
		QFile file(this->where_to_save,this);
		if(!file.open(QIODevice::Truncate|QIODevice::WriteOnly)){
			this->where_to_save=emit this->fileStream_openFailed(file.error(),file.errorString());
			goto streamopen;
		}
		for(quint64 count=0;count<read_count;count++){
			if(this->check_canceled_then_abort())return;
			file.write(this->read(this->buffer_size));
			emit this->file_receive_progress(file.pos());
		}
		if(this->check_canceled_then_abort())return;
		file.write(this->read(final_readsize));
		emit this->file_receive_progress(file.pos());
		file.close();

		rmd6 generator;
		if(this->head_data.ripemd160()==generator.compute_hash(file))
			emit this->file_saved();
		else{
			this->setErrorString(tr("The file has been broken."));
			emit this->error(QAbstractSocket::UnknownSocketError);
			this->disconnectFromHost();
		}
	}
	this->disconnectFromHost();
}

bool tcpSocket::check_canceled_then_abort(){
	if(this->canceled){
		this->setErrorString(tr("The process has been canceled by user."));
		emit this->error(QAbstractSocket::UnknownSocketError);
		this->abort();
		return true;
	}
	return false;
}
void tcpSocket::disconnectFromHostImplementation(){
	this->canceled=true;
	QTcpSocket::disconnectFromHost();
}
tcpSocket &tcpSocket::operator<<(const QString &msg){
	if(this->state()!=QAbstractSocket::ConnectedState) return (*this);
	this->head_data=header(this->senderName,msg);
	QByteArray tmp_buffer;
	QDataStream datastream(&tmp_buffer,QIODevice::WriteOnly);
	datastream<<this->head_data;
	quint16 size=(quint16)tmp_buffer.size();
	this->write((char*)&size,sizeof(__typeof__(size))/sizeof(char));
	if(!this->flush())return (*this);
	this->write(tmp_buffer);
	if(!this->flush())return (*this);
	tmp_buffer.clear();
	tmp_buffer=msg.toUtf8();
	QBuffer memoryStream(&tmp_buffer,this);
	if(!memoryStream.open(QIODevice::ReadOnly)){
		this->setErrorString(tr("Memory Stream couldn't open."));
		emit this->error(QAbstractSocket::UnknownSocketError);
		return (*this);
	}
	while(this->write(memoryStream.read(this->buffer_size))>0)
		if(!this->flush())return (*this);
	memoryStream.close();

	emit this->sentData();
	return (*this);
}
tcpSocket &tcpSocket::operator<<(QFile &src_file){
	QFile file(src_file.fileName(),this);
	if(!this->state()!=QAbstractSocket::ConnectedState)return (*this);
	this->head_data=header(this->senderName,QFileInfo(file));
	QByteArray tmp_buffer;
	QDataStream datastream(tmp_buffer);
	quint16 size=(quint16)tmp_buffer.size();
	datastream<<this->head_data;
	this->write((char*)&size,sizeof(__typeof__(size))/sizeof(char));
	if(!this->flush())return (*this);
	this->write(tmp_buffer);
	if(!this->flush())return (*this);
	tmp_buffer.clear();
	emit this->file_header_sent();
	if(!file.open(QIODevice::ReadOnly)){
		this->setErrorString(tr("The file stream couldn't open."));
		emit this->error(QAbstractSocket::UnknownSocketError);
		return (*this);
	}
	while(this->write(file.read(this->buffer_size))>0&&!this->check_canceled_then_abort()){
		if(!this->flush())return (*this);
		emit this->sending_file_progress(file.pos());
	}
	emit this->sentData();
	return (*this);
}
void tcpSocket::cancel(){this->canceled=true;}
QString tcpSocket::path_to_save() const{return this->where_to_save;}
header tcpSocket::header_data() const{return this->head_data;}
