﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.IO;
using System.Xml;
using System.Xml.Serialization;
using System.Net;
using System.Windows.Forms;
using System.Diagnostics;
using Schemas;

namespace UpdateChecker
{
	public class Updater
	{
		WebClient wc = new WebClient();
		string xmluri = string.Empty, ReleaseFile = string.Empty, TemporaryFile = string.Empty;
		int index = 0;
		public event DownloadProgressChangedEventHandler FileDownloading
		{
			add { wc.DownloadProgressChanged += value; }
			remove { wc.DownloadProgressChanged -= value; }
		}
		public Updater(string XmlUri, int Index)
		{
			xmluri = XmlUri;
			index = Index;
			wc.DownloadFileCompleted += new AsyncCompletedEventHandler(wc_DownloadFileCompleted);
		}
		public Version CheckUpdate(Version CurrentVersion)
		{
			XmlReader xr = XmlReader.Create(xmluri);
			XmlSerializer xs = new XmlSerializer(typeof(Schemas.Menu));
			Schemas.Menu m = (Schemas.Menu)xs.Deserialize(xr);
			ReleaseFile = m.item[index].release;
			Version av = new Version(m.item[index].ver);
			return (av.CompareTo(CurrentVersion) > 0) ? av : new Version(0,0,0,0);
		}
		public void RunUpdate()
		{
			if (string.IsNullOrEmpty(ReleaseFile))
			{
				throw new ArgumentNullException("ReleaseFile",
					"RunUpdateメソッドを実行するためにはCheckUpdateメソッドを先に実行して下さい。");
			}
			TemporaryFile=Path.Combine(Application.StartupPath,Path.GetRandomFileName());
			wc.DownloadFileAsync(new Uri(ReleaseFile), TemporaryFile);
		}
		void wc_DownloadFileCompleted(object sender, AsyncCompletedEventArgs e)
		{
			Process.Start(Path.Combine(Application.StartupPath,"CabinetExtractor.exe"),
				Path.Combine(Application.StartupPath,TemporaryFile) + 
				" " + Process.GetCurrentProcess().Id.ToString());
		}
	}
}