﻿using System;
using System.ComponentModel;
using System.Windows.Forms;

namespace Jasmine
{
	public partial class SendFileInterface : Form
	{
		public SendFileInterface()
		{
			InitializeComponent();
		}

		private void SelectAndDeSelect(bool ReqSelect)
		{
			if (ReqSelect)
			{
				SelectAllBtn.Enabled = false;
				AddressList.BeginUpdate();
				for (int i = 0; i < AddressList.Items.Count; i++)
				{
					AddressList.Items[i].Selected = true;
				}
				AddressList.EndUpdate();
				AddressList.Select();
				SelectAllBtn.Enabled = true;
			}
			else
			{
				AddressList.SelectedItems.Clear();
			}
		}

		private void ChooseFileBtn_Click(object sender, EventArgs e)
		{
			OpenFileDialog of = new OpenFileDialog();
			of.FileOk += new CancelEventHandler(of_FileOk);
			of.ShowDialog();
		}

		private void of_FileOk(object sender, CancelEventArgs e)
		{
			OpenFileDialog of = (OpenFileDialog)sender;
			FilePath.Text = of.FileName;
		}

		private void SelectAllBtn_Click(object sender, EventArgs e)
		{
			SelectAndDeSelect(true);
		}

		private void DeselctAll_Click(object sender, EventArgs e)
		{
			SelectAndDeSelect(false);
		}

		private void AddressList_DoubleClick(object sender, EventArgs e)
		{
			ListView l = (ListView)sender;
			if (l.SelectedItems.Count > 0)
			{
				OKBtn.PerformClick();
			}
		}
	}
}