/*
 * Decompiled with CFR 0.152.
 */
package jp.co.olympus.camerakit;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import jp.co.olympus.camerakit.OLYCamera;
import jp.co.olympus.camerakit.OLYCameraAutoFocusResult;
import jp.co.olympus.camerakit.OLYCameraKitException;
import jp.co.olympus.camerakit.OLYCameraLog;
import jp.co.olympus.camerakit.h;
import jp.co.olympus.camerakit.internal.c;
import jp.co.olympus.camerakit.internal.d;
import jp.co.olympus.camerakit.internal.e;

public class OLYCameraRecordingTrait {
    private OLYCamera.i a;
    private a b;
    private PointF c = null;
    private boolean d = false;

    public boolean isTakingPicture() {
        return this.b != jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.a && this.b != jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b;
    }

    public a getTakingState() {
        return this.b;
    }

    public boolean isRecordingVideo() {
        return this.d;
    }

    public PointF getActualFocusPoint() {
        return this.c;
    }

    protected OLYCameraRecordingTrait(OLYCamera.i adapter) {
        if (adapter == null) {
            throw new NullPointerException();
        }
        if (!(adapter instanceof OLYCamera.i)) {
            throw new IllegalAccessError();
        }
        this.a = adapter;
        this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.a);
    }

    public void start() {
        this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
        this.d = false;
        this.c = null;
    }

    public void stop() {
        this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.a);
        this.d = false;
        this.c = null;
    }

    public void onChangeAutoFocusResult(d.a result) {
        if (result.a().equals("ok") && result.b() != null) {
            RectF rect = result.b();
            this.c = new PointF(rect.centerX(), rect.centerY());
        } else {
            this.c = null;
        }
        this.a.a(new OLYCameraAutoFocusResult(result.a(), result.b()));
    }

    public void startTakingPicture(Map<String, Object> options, final OLYCamera.TakePictureCallback callback) {
        OLYCameraLog.i("options=%s", options);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.e()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the live view is starting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (this.isTakingPicture()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (this.isRecordingVideo()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        OLYCamera.ActionType actionType = this.a.g();
        if (actionType != OLYCamera.ActionType.Single && actionType != OLYCamera.ActionType.Sequential) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.ActionType#Single' mode or 'OLYCamera.ActionType#Sequential' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        int count = 20;
        if (options != null && options.containsKey("_limit")) {
            int limitShootings = (Integer)options.get("_limit");
            if (limitShootings < 0 || limitShootings > 200) {
                OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'options' is invalid.");
                OLYCameraLog.e(theException.getMessage(), new Object[0]);
                if (callback != null) {
                    callback.onErrorOccurred(theException);
                }
                return;
            }
            count = limitShootings;
        }
        if (callback == null) {
            // empty if block
        }
        final int f_count = count;
        this.a.a(new Runnable(){

            @Override
            public void run() {
                String focusResult;
                OLYCamera camera = OLYCameraRecordingTrait.this.a.a();
                e takeEventQueue = OLYCameraRecordingTrait.this.a.f();
                OLYCamera.ActionType actionType = OLYCameraRecordingTrait.this.a.g();
                OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.c);
                takeEventQueue.a();
                try {
                    OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.a(f_count, 100.0);
                            return null;
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                    takeEventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.d);
                if (callback != null) {
                    callback.onProgress(camera, OLYCamera.TakingProgress.BeginFocusing, null);
                }
                long timeout = 10000L;
                c event = null;
                try {
                    event = takeEventQueue.a(timeout);
                    while (event != null && event.a() != c.a.d) {
                        if (event.a() == c.a.j) {
                            event = null;
                            break;
                        }
                        event = takeEventQueue.a(timeout);
                    }
                }
                catch (TimeoutException e3) {
                    event = null;
                }
                if (event == null) {
                    if (actionType == OLYCamera.ActionType.Sequential) {
                        try {
                            OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                                @Override
                                public Void a(h value) throws Exception {
                                    value.h(60.0);
                                    return null;
                                }
                            });
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                    }
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                    takeEventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (event.c() == null) {
                    if (actionType == OLYCamera.ActionType.Sequential) {
                        try {
                            OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                                @Override
                                public Void a(h value) throws Exception {
                                    value.h(60.0);
                                    return null;
                                }
                            });
                        }
                        catch (Exception e5) {
                            // empty catch block
                        }
                    }
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                    takeEventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera has returned a value that is broken or a value of the unexpected.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.e);
                if (callback != null) {
                    d.a afExtension = (d.a)event.c();
                    callback.onProgress(camera, OLYCamera.TakingProgress.EndFocusing, new OLYCameraAutoFocusResult(afExtension.a(), afExtension.b()));
                }
                if ((focusResult = ((d.a)event.c()).a()) == null || focusResult.equals("ng")) {
                    timeout = 10000L;
                    try {
                        while (event != null && event.a() != c.a.j) {
                            event = takeEventQueue.a(timeout);
                        }
                    }
                    catch (TimeoutException e6) {
                        event = null;
                    }
                    if (actionType == OLYCamera.ActionType.Sequential) {
                        try {
                            OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                                @Override
                                public Void a(h value) throws Exception {
                                    value.h(60.0);
                                    return null;
                                }
                            });
                        }
                        catch (Exception e7) {
                            // empty catch block
                        }
                    }
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                    takeEventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera failed to focus.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                timeout = 10000L;
                try {
                    event = takeEventQueue.a(timeout);
                    while (event != null && event.a() != c.a.e) {
                        if (event.a() == c.a.j) {
                            event = null;
                            break;
                        }
                        event = takeEventQueue.a(timeout);
                    }
                }
                catch (TimeoutException e8) {
                    event = null;
                }
                if (event == null) {
                    if (actionType == OLYCamera.ActionType.Sequential) {
                        try {
                            OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                                @Override
                                public Void a(h value) throws Exception {
                                    value.h(60.0);
                                    return null;
                                }
                            });
                        }
                        catch (Exception e9) {
                            // empty catch block
                        }
                    }
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                    takeEventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.f);
                if (callback != null) {
                    callback.onProgress(camera, OLYCamera.TakingProgress.ReadyCapturing, null);
                }
                timeout = 10000L;
                try {
                    event = takeEventQueue.a(timeout);
                    while (event != null && event.a() != c.a.f) {
                        if (event != null && event.a() == c.a.j) {
                            event = null;
                            break;
                        }
                        event = takeEventQueue.a(timeout);
                    }
                }
                catch (TimeoutException e10) {
                    event = null;
                }
                if (event == null) {
                    if (actionType == OLYCamera.ActionType.Sequential) {
                        try {
                            OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                                @Override
                                public Void a(h value) throws Exception {
                                    value.h(60.0);
                                    return null;
                                }
                            });
                        }
                        catch (Exception e11) {
                            // empty catch block
                        }
                    }
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                    takeEventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.g);
                if (callback != null) {
                    callback.onProgress(camera, OLYCamera.TakingProgress.BeginCapturing, null);
                }
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void stopTakingPicture(final OLYCamera.TakePictureCallback callback, final double shutterSpeed) {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.isTakingPicture()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                OLYCamera camera = OLYCameraRecordingTrait.this.a.a();
                e takeEventQueue = OLYCameraRecordingTrait.this.a.f();
                OLYCamera.ActionType actionType = OLYCameraRecordingTrait.this.a.g();
                OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.h);
                if (actionType == OLYCamera.ActionType.Sequential) {
                    try {
                        OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                            @Override
                            public Void a(h value) throws Exception {
                                value.h(60.0);
                                return null;
                            }
                        });
                    }
                    catch (Exception e2) {
                        OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                        takeEventQueue.b();
                        OLYCameraKitException theException = new OLYCameraKitException(e2);
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                }
                long timeout = 30000L;
                if (Double.isNaN(shutterSpeed)) {
                    OLYCameraLog.w("The 'actualShutterSpeed' property is not trusted.", new Object[0]);
                } else {
                    timeout = (long)((double)timeout + shutterSpeed * 1000.0);
                }
                c event = null;
                try {
                    event = takeEventQueue.a(timeout);
                    while (event != null && event.a() != c.a.g) {
                        if (event.a() == c.a.j) {
                            event = null;
                        } else if (event.a() != c.a.i) {
                            event = takeEventQueue.a(timeout);
                            continue;
                        }
                        break;
                    }
                }
                catch (TimeoutException e3) {
                    event = null;
                }
                if (event == null) {
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                    takeEventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (event.a() == c.a.g) {
                    OLYCameraKitException theException;
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.i);
                    if (callback != null) {
                        callback.onProgress(camera, OLYCamera.TakingProgress.BeginNoiseReduction, null);
                    }
                    timeout = 30000L;
                    if (shutterSpeed == 0.0) {
                        OLYCameraLog.w("The 'actualShutterSpeed' property is not trusted.", new Object[0]);
                    } else {
                        timeout = (long)((double)timeout + shutterSpeed * 1000.0);
                    }
                    try {
                        event = takeEventQueue.a(timeout);
                        while (event != null && event.a() != c.a.h) {
                            if (event.a() == c.a.j) {
                                event = null;
                                break;
                            }
                            event = takeEventQueue.a(timeout);
                        }
                    }
                    catch (TimeoutException e4) {
                        event = null;
                    }
                    if (event == null) {
                        OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                        takeEventQueue.b();
                        theException = new OLYCameraKitException("The camera did not respond in time.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.j);
                    if (callback != null) {
                        callback.onProgress(camera, OLYCamera.TakingProgress.EndNoiseReduction, null);
                    }
                    timeout = 30000L;
                    if (shutterSpeed == 0.0) {
                        OLYCameraLog.w("The 'actualShutterSpeed' property is not trusted.", new Object[0]);
                    } else {
                        timeout = (long)((double)timeout + shutterSpeed * 1000.0);
                    }
                    try {
                        event = takeEventQueue.a(timeout);
                        while (event != null && event.a() != c.a.i) {
                            if (event.a() == c.a.j) {
                                event = null;
                                break;
                            }
                            event = takeEventQueue.a(timeout);
                        }
                    }
                    catch (TimeoutException e5) {
                        event = null;
                    }
                    if (event == null) {
                        OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                        takeEventQueue.b();
                        theException = new OLYCameraKitException("The camera did not respond in time.");
                        OLYCameraLog.e(theException.getMessage(), new Object[0]);
                        if (callback != null) {
                            callback.onErrorOccurred(theException);
                        }
                        return;
                    }
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.k);
                    if (callback != null) {
                        callback.onProgress(camera, OLYCamera.TakingProgress.EndCapturing, null);
                    }
                } else {
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.k);
                    if (callback != null) {
                        callback.onProgress(camera, OLYCamera.TakingProgress.EndCapturing, null);
                    }
                }
                timeout = 30000L;
                try {
                    event = takeEventQueue.a(timeout);
                    while (event != null && event.a() != c.a.j) {
                        long variableTimeout = timeout;
                        if (event.a() == c.a.k) {
                            variableTimeout = 60000L;
                        }
                        event = takeEventQueue.a(variableTimeout);
                    }
                }
                catch (TimeoutException e6) {
                    event = null;
                }
                if (event == null) {
                    OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                    takeEventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.l);
                if (callback != null) {
                    callback.onProgress(camera, OLYCamera.TakingProgress.Finished, null);
                }
                OLYCameraRecordingTrait.this.a(jp.co.olympus.camerakit.OLYCameraRecordingTrait$a.b);
                takeEventQueue.b();
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    private void a(a state) {
        OLYCameraLog.d("state=%s", new Object[]{state});
        this.b = state;
    }

    public void startRecordingVideo(Map<String, Object> options, final OLYCamera.CompletedCallback callback) {
        OLYCameraLog.i("options=%s", options);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.e()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the live view is starting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (this.isTakingPicture()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (this.isRecordingVideo()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        OLYCamera.ActionType actionType = this.a.g();
        if (actionType != OLYCamera.ActionType.Movie) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.ActionType#Movie' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                OLYCameraRecordingTrait.this.d = true;
                try {
                    OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.i(10.0);
                            return null;
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraRecordingTrait.this.d = false;
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void stopRecordingVideo(final OLYCamera.CompletedCallback callback) {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.isRecordingVideo()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        this.a.a(new Runnable(){

            @Override
            public void run() {
                try {
                    OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.j(60.0);
                            return null;
                        }
                    });
                }
                catch (Exception e2) {
                    OLYCameraRecordingTrait.this.d = false;
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                OLYCameraRecordingTrait.this.d = false;
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void onStartRecordingVideo() {
        this.a.a(new Runnable(){

            @Override
            public void run() {
                if (OLYCameraRecordingTrait.this.isRecordingVideo()) {
                    return;
                }
                OLYCameraRecordingTrait.this.d = true;
                OLYCameraRecordingTrait.this.a.o();
            }
        });
    }

    public void onStopRecordingVideo() {
        this.a.a(new Runnable(){

            @Override
            public void run() {
                if (!OLYCameraRecordingTrait.this.isRecordingVideo()) {
                    return;
                }
                OLYCameraRecordingTrait.this.d = false;
                OLYCameraRecordingTrait.this.a.p();
            }
        });
    }

    public void lockAutoFocus(final OLYCamera.TakePictureCallback callback) {
        String focusmode;
        String takemode;
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (this.isTakingPicture()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the camera is not performing the shooting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (callback == null) {
            // empty if block
        }
        boolean isFocusModeCAF = false;
        try {
            takemode = this.a.j();
        }
        catch (OLYCameraKitException e2) {
            OLYCameraKitException theException = e2;
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (takemode == null) {
            throw new AssertionError();
        }
        try {
            focusmode = "<TAKEMODE/movie>".equals(takemode) ? this.a.l() : this.a.k();
        }
        catch (OLYCameraKitException e3) {
            OLYCameraKitException theException = e3;
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            if (callback != null) {
                callback.onErrorOccurred(theException);
            }
            return;
        }
        if (focusmode == null) {
            throw new AssertionError();
        }
        final boolean f_isFocusModeCAF = isFocusModeCAF = "<FOCUS_STILL/FOCUS_CAF>".equals(focusmode) || "<FOCUS_MOVIE/FOCUS_CAF>".equals(focusmode);
        this.a.a(new Runnable(){

            @Override
            public void run() {
                e eventQueue = OLYCameraRecordingTrait.this.a.f();
                eventQueue.a();
                try {
                    OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.m(10.0);
                            return null;
                        }
                    });
                }
                catch (Exception e2) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e2);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                try {
                    OLYCameraRecordingTrait.this.a.a(new OLYCamera.c<Void, h>(){

                        @Override
                        public Void a(h value) throws Exception {
                            value.l(10.0);
                            return null;
                        }
                    });
                }
                catch (Exception e3) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException(e3);
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (f_isFocusModeCAF) {
                    eventQueue.b();
                    if (callback != null) {
                        callback.onCompleted();
                    }
                    return;
                }
                long timeoutInMillis = 10000L;
                c event = null;
                try {
                    event = eventQueue.a(timeoutInMillis);
                    if (event.a() != c.a.d) {
                        event = null;
                    }
                }
                catch (TimeoutException e4) {
                    // empty catch block
                }
                if (event == null || event.c() == null) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera did not respond in time.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                d.a afExtension = (d.a)event.c();
                String focusResult = afExtension.a();
                if (focusResult == null || focusResult.equals("ng")) {
                    eventQueue.b();
                    OLYCameraKitException theException = new OLYCameraKitException("The camera failed to focus.");
                    OLYCameraLog.e(theException.getMessage(), new Object[0]);
                    if (callback != null) {
                        callback.onErrorOccurred(theException);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onProgress(OLYCameraRecordingTrait.this.a.a(), OLYCamera.TakingProgress.EndFocusing, new OLYCameraAutoFocusResult(afExtension.a(), afExtension.b()));
                }
                eventQueue.b();
                if (callback != null) {
                    callback.onCompleted();
                }
            }
        });
    }

    public void unlockAutoFocus() throws OLYCameraKitException {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.m(10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void setAutoFocusPoint(PointF point) throws OLYCameraKitException {
        RectF touchArea;
        OLYCameraLog.i("", new Object[0]);
        OLYCamera.LiveViewSize liveViewSize = this.a.h();
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.e()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the live view is starting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!new RectF(0.0f, 0.0f, 1.0f, 1.0f).contains(point.x, point.y)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'point' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            touchArea = this.a.m();
        }
        catch (OLYCameraKitException e2) {
            OLYCameraKitException theException = e2;
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!touchArea.contains(point.x, point.y)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'point' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final Point cgiPoint = new Point((int)(point.x * (float)liveViewSize.getWidth()), (int)(point.y * (float)liveViewSize.getHeight()));
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.a(cgiPoint, 10.0);
                    return null;
                }
            });
        }
        catch (Exception e3) {
            OLYCameraKitException theException = new OLYCameraKitException(e3);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void clearAutoFocusPoint() throws OLYCameraKitException {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.k(10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void lockAutoExposure() throws OLYCameraKitException {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.p(10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.o(10.0);
                    return null;
                }
            });
        }
        catch (Exception e3) {
            OLYCameraKitException theException = new OLYCameraKitException(e3);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void unlockAutoExposure() throws OLYCameraKitException {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.p(10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void setAutoExposurePoint(PointF point) throws OLYCameraKitException {
        RectF touchArea;
        OLYCameraLog.i("", new Object[0]);
        OLYCamera.LiveViewSize liveViewSize = this.a.h();
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.e()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation is allowed only when the live view is starting.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!new RectF(0.0f, 0.0f, 1.0f, 1.0f).contains(point.x, point.y)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'point' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            touchArea = this.a.n();
        }
        catch (OLYCameraKitException e2) {
            OLYCameraKitException theException = e2;
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!touchArea.contains(point.x, point.y)) {
            OLYCameraKitException theException = new OLYCameraKitException("The value for parameter 'point' is invalid.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        final Point cgiPoint = new Point((int)(point.x * (float)liveViewSize.getWidth()), (int)(point.y * (float)liveViewSize.getHeight()));
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.b(cgiPoint, 10.0);
                    return null;
                }
            });
        }
        catch (Exception e3) {
            OLYCameraKitException theException = new OLYCameraKitException(e3);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public void clearAutoExposurePoint() throws OLYCameraKitException {
        OLYCameraLog.i("", new Object[0]);
        if (!this.a.b()) {
            OLYCameraKitException theException = new OLYCameraKitException("The instance is not connected to the camera.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.c()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the instance is connected to the camera over Wi-Fi.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        if (!this.a.d()) {
            OLYCameraKitException theException = new OLYCameraKitException("The operation requires that the camera entered 'OLYCamera.RunMode#Recording' mode.");
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
        try {
            this.a.a(new OLYCamera.c<Void, h>(){

                @Override
                public Void a(h value) throws Exception {
                    value.n(10.0);
                    return null;
                }
            });
        }
        catch (Exception e2) {
            OLYCameraKitException theException = new OLYCameraKitException(e2);
            OLYCameraLog.e(theException.getMessage(), new Object[0]);
            throw theException;
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        public static final /* enum */ a d = new a();
        public static final /* enum */ a e = new a();
        public static final /* enum */ a f = new a();
        public static final /* enum */ a g = new a();
        public static final /* enum */ a h = new a();
        public static final /* enum */ a i = new a();
        public static final /* enum */ a j = new a();
        public static final /* enum */ a k = new a();
        public static final /* enum */ a l = new a();
        private static final /* synthetic */ a[] m;

        public static a[] a() {
            return (a[])m.clone();
        }

        public static a a(String name) {
            return Enum.valueOf(a.class, name);
        }

        static {
            m = new a[]{a, b, c, d, e, f, g, h, i, j, k, l};
        }
    }
}

