package glpkeclipse.editors;

import org.eclipse.jface.text.rules.*;

public class GlpkPartitionScanner extends RuleBasedPartitionScanner {
	public final static String GLPK_COMMENT = "__glpk_comment";
	public final static String GLPK_TAG = "__glpk_tag";

	public GlpkPartitionScanner() {

		IToken glpkComment = new Token(GLPK_COMMENT);
		IToken tag = new Token(GLPK_TAG);

		IPredicateRule[] rules = new IPredicateRule[2];

		rules[0] = new MultiLineRule("<!--", "-->", glpkComment);
		rules[1] = new TagRule(tag);

		setPredicateRules(rules);
	}
}
