package jp.sourceforge.glad.org.seasar.framework.model.domain;

import java.io.Serializable;

import jp.sourceforge.glad.org.seasar.framework.model.repository.PersonRepository;

/**
 * @author GLAD!!
 */
public class Person implements Serializable {

    private static final long serialVersionUID = 1L;

    String name;

    int age;

    transient PersonRepository repository;

    public Person() {
    }

    public Person(final String name, final int age) {
        this.name = name;
        this.age = age;
    }

    public Person(final Person other) {
        this.name = other.name;
        this.age = other.age;
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public int getAge() {
        return age;
    }

    public void setAge(final int age) {
        this.age = age;
    }

    public PersonRepository getRepository() {
        return repository;
    }

    public void setRepository(final PersonRepository repository) {
        this.repository = repository;
    }

    public void save() {
        repository.savePerson(this);
    }

    public String toString() {
        return "Person {name=" + name + ", age=" + age + "}";
    }

}
