package jp.sourceforge.glad.org.seasar.dao.tiger;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.glad.org.seasar.dao.tiger.dao.EmployeeDao;
import jp.sourceforge.glad.org.seasar.dao.tiger.entity.Employee;
import jp.sourceforge.glad.org.seasar.extension.unit.S2TestCase;

import org.seasar.dao.tiger.FetchHandler;

public class GenericDaoTest extends S2TestCase {

    EmployeeDao dao;

    @Override
    protected void setUp() throws Exception {
        include("GenericDaoTest.dicon");
    }

    public void testGetByIdTx() {
        setUpDbForClass("EMP", "DEPT");
        Employee employee = dao.getById(7654L);
        assertEquals(7654, employee.getEmpNo());
        assertEquals("MARTIN", employee.getEname());
        assertEquals("SALESMAN", employee.getJob());
        assertEquals(7698, employee.getManager());
        assertEquals("1981-09-28", employee.getHireDate());
        assertEquals(1250, employee.getSalary());
        assertEquals(1400.0, employee.getCommission());
        assertEquals(30, employee.getDeptNo());
        assertEquals("2000-01-01 00:00:00", employee.getTimestamp());
        assertData(employee);
    }

    public void testGetByIdNoneTx() {
        setUpDbForClass("EMP", "DEPT");
        assertNull(dao.getById(0L));
    }

    public void testFindAllTx() {
        setUpDbForClass("EMP", "DEPT");
        List<Employee> list = dao.findAll();
        assertEquals(14, list.size());
        assertData(list);
    }

    public void testIterateAllTx() {
        setUpDbForClass("EMP", "DEPT");
        final List<Employee> list = new ArrayList<Employee>();
        dao.iterateAll(new FetchHandler<Employee>() {
            int count = 0;
            public boolean execute(Employee employee) {
                list.add(employee);
                return (++count < 5);
            }
        });
        assertEquals(5, list.size());
        assertData(list);
    }

    public void testInsertTx() {
        setUpDbForClass("EMP", "DEPT");
        Employee employee = new Employee(8001, "Hoge", "CLERK", 7698,
                Date.valueOf("2001-02-03"), BigDecimal.valueOf(1200), null, 30);
        int count = dao.insert(employee);
        assertEquals(1, count);
        assertDb("EMP");
    }

    public void testInsertBatchTx() {
        setUpDbForClass("EMP", "DEPT");
        List<Employee> list = new ArrayList<Employee>();
        list.add(new Employee(8001, "Hoge", "CLERK", 7698,
                Date.valueOf("2001-02-03"), BigDecimal.valueOf(1200), null, 30));
        list.add(new Employee(8002, "Fuga", "SALESMAN", 7698,
                Date.valueOf("2002-03-04"), BigDecimal.valueOf(2300), null, 30));
        int[] counts = dao.insertBatch(list);
        assertEquals(2, counts.length);
        assertEquals(1, counts[0]);
        assertEquals(1, counts[1]);
        assertDb("EMP");
    }

    public void testUpdateTx() {
        setUpDbForClass("EMP", "DEPT");
        Employee employee = dao.getById(7499L);
        assertEquals("ALLEN", employee.getEname());
        
        employee.setEname("Hoge");
        employee.setJob("MANGER");
        employee.setManager(7839);
        employee.setHireDate(Date.valueOf("2001-02-03"));
        employee.setSalary(BigDecimal.valueOf(2300));
        employee.setCommission(null);
        employee.setDeptNo(20);
        
        int count = dao.update(employee);
        assertEquals(1, count);
        assertDb("EMP");
    }

    public void testUpdateBatchTx() {
        setUpDbForClass("EMP", "DEPT");
        Employee employee = dao.getById(7499L);
        assertEquals("ALLEN", employee.getEname());
        
        employee.setEname("Hoge");
        employee.setJob("MANGER");
        employee.setManager(7839);
        employee.setHireDate(Date.valueOf("2001-02-03"));
        employee.setSalary(BigDecimal.valueOf(2300));
        employee.setCommission(null);
        employee.setDeptNo(20);
        
        List<Employee> list = new ArrayList<Employee>();
        list.add(employee);
        int[] counts = dao.updateBatch(list);
        assertEquals(1, counts.length);
        assertEquals(1, counts[0]);
        //assertDb("EMP");
    }

    public void testDeleteTx() {
        setUpDbForClass("EMP", "DEPT");
        Employee employee = dao.getById(7499L);
        assertEquals("ALLEN", employee.getEname());
        int count = dao.delete(employee);
        assertEquals(1, count);
        assertDb("EMP");
    }

    public void testDeleteBatchTx() {
        setUpDbForClass("EMP", "DEPT");
        Employee employee = dao.getById(7499L);
        assertEquals("ALLEN", employee.getEname());
        List<Employee> list = new ArrayList<Employee>();
        list.add(employee);
        int[] counts = dao.deleteBatch(list);
        assertEquals(1, counts.length);
        assertEquals(1, counts[0]);
        //assertDb("EMP");
    }

}
