package jp.sourceforge.glad.org.seasar.framework.model;

/**
 * Modelオブジェクトを生成します。
 * 
 * @author GLAD!!
 */
public interface ModelFactory {

    /**
     * 指定されたクラスのModelオブジェクトを生成します。
     * <p>
     * 生成されたオブジェクトには、必要なコンポーネントが注入され、アスペクトが適用されます。
     * 
     * @param <T>
     *      オブジェクトの型
     * @param clazz
     *      オブジェクトのクラス
     * @param args
     *      コンストラクタの引数
     * @return
     *      生成されたModelオブジェクト
     */
    <T> T create(Class<T> clazz, Object... args);

}
