package jp.sourceforge.glad.org.seasar.extension.unit.impl;

import java.lang.reflect.Method;

import jp.sourceforge.glad.org.seasar.extension.unit.S2UnitContext;
import junit.framework.TestCase;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;

public class S2UnitContextImpl implements S2UnitContext {

    /** ロガー */
    protected static final Logger logger
            = Logger.getLogger(S2UnitContextImpl.class);

    /** ルートのS2コンテナ */
    protected S2Container container;

    protected String resourcesPath = "src/test/resources";

    protected String setupSuffix = "_SETUP";

    protected String expectedSuffix = "_EXPECTED";

    protected String xlsExt = ".xls";

    /** テストデータの文字列に含まれる空白を取り除くかどうかを表すフラグ。デフォルトは<code>true</code> */
    protected boolean trimString = true;

    /** JTAを使用するかどうかを表すフラグ。デフォルトは<code>false</code> */
    protected boolean jtaEnabled = false;

    public S2Container getContainer() {
        return container;
    }

    /**
     * S2コンテナを設定します。
     * 
     * @param container
     *          S2コンテナ
     */
    public void setContainer(final S2Container container) {
        this.container = container.getRoot();
    }

    public String getResourcesPath() {
        return resourcesPath;
    }

    public String getTestClassPackagePath(Class<?> testClass) {
        return testClass.getName().replace('.', '/')
                .replaceFirst("/[^/]+$", "");
    }

    public String getTestClassShortName(Class<?> testClass) {
        return ClassUtil.getShortClassName(testClass);
    }

    public String getTestMethodName(Method testMethod) {
        return testMethod.getName();
    }

    public String getClassSetupXlsPath(TestCase test) {
        return test.getClass().getName().replace('.', '/')
                + setupSuffix + xlsExt;
    }

    public String getMethodSetupXlsPath(TestCase test) {
        return test.getClass().getName().replace('.', '/')
                + '_' + test.getName() + setupSuffix + xlsExt;
    }

    public String getExpectedXlsPath(TestCase test) {
        return test.getClass().getName().replace('.', '/')
                + '_' + test.getName() + expectedSuffix + xlsExt;
    }

    public String getExpectedXlsPath(TestCase test, String suffix) {
        return test.getClass().getName().replace('.', '/')
                + '_' + test.getName() + expectedSuffix + suffix + xlsExt;
    }

    public boolean isTrimString() {
        return trimString;
    }

    public void setTrimString(final boolean trimString) {
        this.trimString = trimString;
    }

    public boolean isJtaEnabled() {
        return jtaEnabled;
    }

    /**
     * JTAを使用する場合<code>true</code>を設定します。
     * 
     * @param jtaEnabled
     *          JTAを使用する場合<code>true</code>、使用しない場合<code>false</code>
     */
    public void setJtaEnabled(boolean jtaEnabled) {
        this.jtaEnabled = jtaEnabled;
    }

}
