package com.example.mule.util;

import junit.framework.TestCase;

public class MuleExampleUtilsTest extends TestCase {

    public void testGetTypeName() {
        assertEquals("int",
                MuleExampleUtils.getTypeName(int.class));
        assertEquals("java.lang.String",
                MuleExampleUtils.getTypeName(String.class));
        assertEquals("int[]",
                MuleExampleUtils.getTypeName(int[].class));
        assertEquals("java.lang.String[]",
                MuleExampleUtils.getTypeName(String[].class));
    }

    public void testToStringObject() {
        assertEquals("123", MuleExampleUtils.toString(123));
        assertEquals("abc", MuleExampleUtils.toString("abc"));
        assertEquals("[1, 2, 3]",
                MuleExampleUtils.toString(new int[] { 1, 2, 3 }));
        assertEquals("[a, b, c]",
                MuleExampleUtils.toString(new String[] { "a", "b", "c" }));
    }

}
