package jp.sourceforge.glad.reflect;

import java.util.Arrays;

import junit.framework.TestCase;

public class ReflectionUtilsTest extends TestCase {

    public void testClassToString() {
        assertEquals("int",   ReflectionUtils.toString(int.class));
        assertEquals("int[]", ReflectionUtils.toString(int[].class));
        assertEquals("java.lang.String",
                ReflectionUtils.toString(String.class));
        assertEquals("java.lang.String[]",
                ReflectionUtils.toString(String[].class));
        assertEquals("jp.sourceforge.glad.reflect.ReflectionUtilsTest$Example",
                ReflectionUtils.toString(Example.class));
        assertEquals("jp.sourceforge.glad.reflect.ReflectionUtilsTest$Example[]",
                ReflectionUtils.toString(Example[].class));
    }

    public void testClassToSimpleString() {
        assertEquals("int",   ReflectionUtils.toSimpleString(int.class));
        assertEquals("int[]", ReflectionUtils.toSimpleString(int[].class));
        assertEquals("String",   ReflectionUtils.toSimpleString(String.class));
        assertEquals("String[]", ReflectionUtils.toSimpleString(String[].class));
        assertEquals("Example",   ReflectionUtils.toSimpleString(Example.class));
        assertEquals("Example[]", ReflectionUtils.toSimpleString(Example[].class));
    }

    public void testFieldToString() {
        assertEquals("jp.sourceforge.glad.reflect.ReflectionUtilsTest$Example#value",
                ReflectionUtils.fieldToString(Example.class, "value"));
    }

    public void testFieldToSimpleString() {
        assertEquals("Example#value",
                ReflectionUtils.fieldToSimpleString(Example.class, "value"));
    }

    public void testMethodToString() {
        assertEquals("jp.sourceforge.glad.reflect.ReflectionUtilsTest$Example"
                + "#doSomething(int, java.lang.String...)",
                ReflectionUtils.methodToString(Example.class,
                        "doSomething", true, int.class, String[].class));
    }

    public void testMethodToSimpleString() {
        assertEquals("Example#doSomething(int, String...)",
                ReflectionUtils.methodToSimpleString(Example.class,
                        "doSomething", true, int.class, String[].class));
    }

    public static class Example {
        public static final int CONSTANT = 123;
        private Object value;
        public Example(Object value) {
            this.value = value;
        }
        public Object doSomething(int n, String... args) {
            return "Example(" + value + ").doSomething("
                    + n + ", " + Arrays.deepToString(args) + ')';
        }
    }

}
