package jp.sourceforge.glad.reflect;

import java.util.Arrays;

import junit.framework.TestCase;

public class MethodAdapterTest extends TestCase {

    public void testInvoke() {
        Example target = new Example();
        MethodAdapter<String> doSomething = new MethodAdapter<String>(
                Example.class, "doSomething", int.class, Object[].class);
        doSomething.makeAccessible();
        assertEquals("Example.doSomething(123, [abc, def])",
                doSomething.invoke(target, 123, "abc", "def"));
    }

    public static class Example {
        public String doSomething(int n, Object... args) {
            return "Example.doSomething("
                    + n + ", " + Arrays.deepToString(args) + ')';
        }
    }

}
