package jp.sourceforge.glad.collection;

import java.util.Arrays;

import junit.framework.TestCase;

public class ListAdapterTest extends TestCase {

    public void testAddAll() {
        ListAdapter<String> list = new ListAdapter<String>()
            .addAll("1", "2", "3");
        assertAdapterEquals("[1, 2, 3]", list);
        assertSame(list, list.addAll("4", "5"));
        assertAdapterEquals("[1, 2, 3, 4, 5]", list);
        assertSame(list, list.addAll(2, "a", "b"));
        assertAdapterEquals("[1, 2, a, b, 3, 4, 5]", list);
        
        list.clear().addAll(Arrays.asList("1", "2", "3"));
        assertSame(list, list.addAll(Arrays.asList("4", "5")));
        assertAdapterEquals("[1, 2, 3, 4, 5]", list);
        assertSame(list, list.addAll(2, Arrays.asList("a", "b")));
        assertAdapterEquals("[1, 2, a, b, 3, 4, 5]", list);
    }

    public void testSort() {
        ListAdapter<String> list = new ListAdapter<String>()
            .addAll("1", "4", "3", "2", "5");
        assertAdapterEquals("[1, 4, 3, 2, 5]", list);
        assertSame(list, list.sort());
        assertAdapterEquals("[1, 2, 3, 4, 5]", list);
    }

    public void testBinarySearch() {
        ListAdapter<String> list = new ListAdapter<String>()
            .addAll("1", "4", "3", "2", "5");
        assertAdapterEquals("[1, 4, 3, 2, 5]", list);
        assertSame(list, list.sort());
        assertAdapterEquals("[1, 2, 3, 4, 5]", list);
        assertEquals(1, list.binarySearch("2"));
        assertEquals(3, list.binarySearch("4"));
    }

    public void testReverse() {
        ListAdapter<String> list = new ListAdapter<String>()
            .addAll("1", "4", "3", "2", "5");
        assertAdapterEquals("[1, 4, 3, 2, 5]", list);
        assertSame(list, list.reverse());
        assertAdapterEquals("[5, 2, 3, 4, 1]", list);
    }

    static void assertAdapterEquals(String expected, ListAdapter<?> actual) {
        assertEquals(expected, actual.toString());
    }

}
