package jp.sourceforge.glad.calendar.era;

import java.util.Locale;

import jp.sourceforge.glad.calendar.CalendarConsts;
import jp.sourceforge.glad.io.IOUtils;
import junit.framework.TestCase;

/**
 * {@link JapaneseEraTest} の単体テスト。
 *
 * @author GLAD!!
 */
public class JapaneseEraTest extends TestCase {

    public void testShowa() {
        JapaneseEra era = new JapaneseEra(3, "Showa", "S", "1926-12-25");
        assertEquals(3, era.getId());
        assertEquals("Showa", era.getName());
        assertEquals("S",     era.getAbbr());
        assertEquals(-1357603200000L, era.getSince());
        assertEquals(1926, era.getSinceYear());
        
        assertEquals("S", era.getShortName());
        assertEquals("S", era.getShortName(Locale.JAPAN));
        assertEquals("昭", era.getMediumName());
        assertEquals("昭", era.getMediumName(Locale.JAPAN));
        assertEquals("昭和", era.getLongName());
        assertEquals("昭和", era.getLongName(Locale.JAPAN));
        
        assertEquals("3: [S] Showa", era.toString());
        
        try {
            era.getGregorianYear(0);
            fail();
        } catch (IllegalArgumentException e) {}
        assertEquals(1926, era.getGregorianYear(1));
        assertEquals(1989, era.getGregorianYear(64));
        assertEquals(2008, era.getGregorianYear(83));
        
        try {
            era.getYearOfEra(1925);
            fail();
        } catch (IllegalArgumentException e) {}
        assertEquals(1,  era.getYearOfEra(1926));
        assertEquals(64, era.getYearOfEra(1989));
        assertEquals(83, era.getYearOfEra(2008));
    }

    public void testHashCode() {
        JapaneseEra showa = new JapaneseEra(3, "Showa", "S", "1926-12-25");
        assertEquals(3, showa.hashCode());
    }

    public void testEquals() {
        JapaneseEra showa  = new JapaneseEra(3, "Showa",  "S", "1926-12-25");
        JapaneseEra heisei = new JapaneseEra(4, "Heisei", "H", "1989-01-08");
        
        assertFalse(showa.equals(null));
        assertFalse(showa.equals(new Object()));

        assertEquals(showa, showa);
        assertEquals(showa, new JapaneseEra(3, "昭和", "昭", "1926-12-25"));
        
        assertFalse(showa.equals(heisei));
        assertFalse(heisei.equals(showa));
    }

    public void testCompareTo() {
        JapaneseEra showa  = new JapaneseEra(3, "Showa",  "S", "1926-12-25");
        JapaneseEra heisei = new JapaneseEra(4, "Heisei", "H", "1989-01-08");
        assertEquals(0, showa.compareTo(showa));
        assertTrue(showa.compareTo(heisei) < 0);
        assertTrue(heisei.compareTo(showa) > 0);
    }

    public void testSerialize() {
        JapaneseEra showa = JapaneseEra.getInstance(CalendarConsts.SHOWA);
        byte[] ser = IOUtils.serialize(showa);
        Object deser = IOUtils.deserialize(ser);
        assertSame(showa, deser);
        
        JapaneseEra dummy = new JapaneseEra(-1, "Dummy", "#", "0123-01-23");
        byte[] ser2 = IOUtils.serialize(dummy);
        Object deser2 = IOUtils.deserialize(ser2);
        assertEquals(dummy, deser2);
    }

}
