package jp.sourceforge.glad.dsl.xml;

public interface XmlDocument<T extends XmlDocument<T>> {

    T add(XmlDeclaration decl);
    T add(ProcessingInstruction proc);
    T add(DOCTYPE doctype);
    T add(XmlElement<?> element);
    T comment(Object comment);
    T endl();

    XmlDeclaration xml();
    XmlDeclaration xml(Object version);
    XmlDeclaration xml(Object version, Object encoding);

    DOCTYPE DOCTYPE(String root, String kind, String id, Object... uris);

    XmlElement<?> elem(String name);
    <E extends XmlElement<E>> E elem(Class<E> clazz);

}
