package jp.sourceforge.glad.collection.iteration;

import jp.sourceforge.glad.collection.exception.BreakException;
import jp.sourceforge.glad.collection.exception.ContinueException;
import jp.sourceforge.glad.collection.exception.ReturnException;

public class IterationUtils {

    public static void doContinue() {
        throw new ContinueException();
    }

    public static void doContinue(Object label) {
        throw new ContinueException(label);
    }

    public static void doBreak() {
        throw new BreakException();
    }

    public static void doBreak(Object label) {
        throw new BreakException(label);
    }

    public static void doReturn() {
        throw new ReturnException();
    }

    public static void doReturn(Object result) {
        throw new ReturnException(result);
    }

}
