/*
 * Copyright (C) 2008-2009 GLAD!! (ITO Yoshiichi)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.glad.calendar.joda.format;

import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;

/**
 * 
 * @author GLAD!!
 */
public class DateTimeFormatterBuilder
        extends org.joda.time.format.DateTimeFormatterBuilder {

    public DateTimeFormatterBuilder appendEraShortText() {
        return appendShortText(DateTimeFieldType.era());
    }

    public DateTimeFormatterBuilder appendYearOfEraText() {
        return appendText(DateTimeFieldType.yearOfEra());
    }

    // ---- extends org.joda.time.format.DateTimeFormatterBuilder

    @Override
    public DateTimeFormatterBuilder append(DateTimeFormatter formatter) {
        super.append(formatter);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder append(DateTimePrinter printer) {
        super.append(printer);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder append(DateTimeParser parser) {
        super.append(parser);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder append(
            DateTimePrinter printer, DateTimeParser parser) {
        super.append(printer, parser);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder append(
            DateTimePrinter printer, DateTimeParser[] parsers) {
        super.append(printer, parsers);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendOptional(DateTimeParser parser) {
        super.appendOptional(parser);
        return this;
    }

    // ----

    @Override
    public DateTimeFormatterBuilder appendLiteral(char c) {
        super.appendLiteral(c);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendLiteral(String text) {
        super.appendLiteral(text);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendDecimal(
            DateTimeFieldType fieldType, int minDigits, int maxDigits) {
        super.appendDecimal(fieldType, minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendFixedDecimal(
            DateTimeFieldType fieldType, int numDigits) {
        super.appendFixedDecimal(fieldType, numDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendSignedDecimal(
            DateTimeFieldType fieldType, int minDigits, int maxDigits) {
        super.appendSignedDecimal(fieldType, minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendFixedSignedDecimal(
            DateTimeFieldType fieldType, int numDigits) {
        super.appendFixedSignedDecimal(fieldType, numDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendText(
            DateTimeFieldType fieldType) {
        super.appendText(fieldType);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendShortText(
            DateTimeFieldType fieldType) {
        super.appendShortText(fieldType);
        return this;
    }

    // ----

    @Override
    public DateTimeFormatterBuilder appendEraText() {
        super.appendEraText();
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendCenturyOfEra(
            int minDigits, int maxDigits) {
        super.appendCenturyOfEra(minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendYear(int minDigits, int maxDigits) {
        super.appendYear(minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendYearOfEra(
            int minDigits, int maxDigits) {
        super.appendYearOfEra(minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendYearOfCentury(
            int minDigits, int maxDigits) {
        super.appendYearOfCentury(minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendTwoDigitYear(int pivot) {
        super.appendTwoDigitYear(pivot);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendTwoDigitYear(
            int pivot, boolean lenientParse) {
        super.appendTwoDigitYear(pivot, lenientParse);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendWeekOfWeekyear(int minDigits) {
        super.appendWeekOfWeekyear(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendWeekyear(
            int minDigits, int maxDigits) {
        super.appendWeekyear(minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int pivot) {
        super.appendTwoDigitWeekyear(pivot);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendTwoDigitWeekyear(
            int pivot, boolean lenientParse) {
        super.appendTwoDigitWeekyear(pivot, lenientParse);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendMonthOfYear(int minDigits) {
        super.appendMonthOfYear(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendMonthOfYearText() {
        super.appendMonthOfYearText();
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendMonthOfYearShortText() {
        super.appendMonthOfYearShortText();
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendDayOfYear(int minDigits) {
        super.appendDayOfYear(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendDayOfMonth(int minDigits) {
        super.appendDayOfMonth(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendDayOfWeek(int minDigits) {
        super.appendDayOfWeek(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendDayOfWeekText() {
        super.appendDayOfWeekText();
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendDayOfWeekShortText() {
        super.appendDayOfWeekShortText();
        return this;
    }

    // ----

    @Override
    public DateTimeFormatterBuilder appendHalfdayOfDayText() {
        super.appendHalfdayOfDayText();
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendHourOfDay(int minDigits) {
        super.appendHourOfDay(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendHourOfHalfday(int minDigits) {
        super.appendHourOfHalfday(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendClockhourOfDay(int minDigits) {
        super.appendClockhourOfDay(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendClockhourOfHalfday(int minDigits) {
        super.appendClockhourOfHalfday(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendMinuteOfDay(int minDigits) {
        super.appendMinuteOfDay(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendMinuteOfHour(int minDigits) {
        super.appendMinuteOfHour(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendSecondOfDay(int minDigits) {
        super.appendSecondOfDay(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendSecondOfMinute(int minDigits) {
        super.appendSecondOfMinute(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendMillisOfDay(int minDigits) {
        super.appendMillisOfDay(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendMillisOfSecond(int minDigits) {
        super.appendMillisOfSecond(minDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendFraction(
            DateTimeFieldType fieldType, int minDigits, int maxDigits) {
        super.appendFraction(fieldType, minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendFractionOfDay(
            int minDigits, int maxDigits) {
        super.appendFractionOfDay(minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendFractionOfHour(
            int minDigits, int maxDigits) {
        super.appendFractionOfHour(minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendFractionOfMinute(
            int minDigits, int maxDigits) {
        super.appendFractionOfMinute(minDigits, maxDigits);
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendFractionOfSecond(
            int minDigits, int maxDigits) {
        super.appendFractionOfSecond(minDigits, maxDigits);
        return this;
    }

    // ----

    @Override
    public DateTimeFormatterBuilder appendTimeZoneId() {
        super.appendTimeZoneId();
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendTimeZoneName() {
        super.appendTimeZoneName();
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendTimeZoneShortName() {
        super.appendTimeZoneShortName();
        return this;
    }

    @Override
    public DateTimeFormatterBuilder appendTimeZoneOffset(
            String zeroOffsetText, boolean showSeparators,
            int minFields, int maxFields) {
        super.appendTimeZoneOffset(
                zeroOffsetText, showSeparators, minFields, maxFields);
        return this;
    }

    // ----

    @Override
    public DateTimeFormatterBuilder appendPattern(String pattern) {
        super.appendPattern(pattern);
        return this;
    }

}
