package example.hello.action;

import javax.ejb.EJB;

import org.seasar.struts.annotation.Execute;
import org.seasar.struts.annotation.Required;

import example.hello.dto.HelloRequest;
import example.hello.exception.HelloException;
import example.hello.exception.HelloRuntimeException;
import example.hello.service.HelloService;

public class HelloAction {

    @Required
    public String name;

    public String message;

    @EJB
    HelloService service;

    @Execute(validator = false)
    public String index() {
        return "index.html";
    }

    @Execute(validator = false)
    public String index_jsp() {
        return "index.jsp";
    }

    @Execute(input = "index.html")
    public String sayHello() {
        message = sayHello(name);
        return "sayHello.html";
    }

    @Execute(input = "index.html", urlPattern="sayHello/{name}")
    public String sayHelloWithName() {
        message = sayHello(name);
        return "sayHello.html";
    }

    @Execute(input = "index.jsp")
    public String sayHello_jsp() {
        message = sayHello(name);
        return "sayHello.jsp";
    }

    @Execute(validator = false)
    public String back() {
        return "/hello/?redirect=true";
    }

    String sayHello(String name) {
        HelloRequest request = new HelloRequest();
        if (name != null) {
            request.setName(name);
        }
        try {
            return service.sayHello(request).getMessage();
        } catch (HelloException e) {
            throw new HelloRuntimeException(e);
        }
    }

}
