package haskell.prelude;

import haskell.lang.Data;

/**
 * data () = ()
 *     deriving (Eq, Ord, Enum, Bounded)
 */
public class Unit
        extends AbstractEnum<Unit>
        implements Data<Unit>,
                Eq<Unit>,
                Ord<Unit>,
                Enum<Unit>,
                Bounded<Unit> {

    Unit() {
        super("()");
    }

    /**
     * ()
     */
    public static Unit Unit_() {
        return Unit;
    }

    static final Unit Unit = new Unit();

    // ---- java.lang.Object

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(final Unit other) {
        return true;
    }

    // ---- java.lang.Comparable

    public int compareTo(final Unit other) {
        return 0;
    }

    // ---- instance Eq ()

    protected Eq.Support<Unit> _Eq_() {
        return Eq();
    }

    public static Eq.Support<Unit> Eq() {
        return Ord;
    }

    // ---- instance Ord ()

    protected Ord.Support<Unit> _Ord_() {
        return Ord();
    }

    public static Ord.Support<Unit> Ord() {
        return Ord;
    }

    static final Ord.Support<Unit> Ord
            = new AbstractOrd.Support<Unit>(Unit.class);

    // ---- instance Enum ()

    protected Enum.Support<Unit> _Enum_() {
        return Enum();
    }

    public static Enum.Support<Unit> Enum() {
        return Enum;
    }

    static final Enum.Support<Unit> Enum
            = new Enum.Support<Unit>(Unit.class) {

        /**
         * toEnum n
         */
        public Unit toEnum(final Int n) {
            return Unit_();
        }

        /**
         * fromEnum x
         */
        public Int fromEnum(final Unit x) {
            return Int.Zero();
        }
    };

    // ---- instance Bounded ()

    public static Bounded.Support<Unit> Bounded() {
        return Bounded;
    }

    static final Bounded.Support<Unit> Bounded
            = new Bounded.Support<Unit>() {

        /**
         * minBound
         */
        public Unit minBound() {
            return Unit_();
        }

        /**
         * maxBound
         */
        public Unit maxBound() {
            return Unit_();
        }

    };

}
