package haskell.prelude;

public class Function3<A, B, C, D>
        extends Function2<A, B, Function<C, D>> {

    public Function3() {
    }

    public Function3(final java.lang.String name) {
        super(name);
    }

    /**
     * public static D name(A x, B x, C z);
     */
    public Function3(
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String name) {
        super(name, clazz, returnType, name, 3);
    }

    /**
     * public D name(A x, B x, C z);
     */
    public Function3(
            final Object target,
            final Class<?> returnType,
            final java.lang.String name) {
        super(name, target, returnType, name, 3);
    }

    /**
     * public static D methodName(A x, B x, C z);
     */
    public Function3(
            final java.lang.String name,
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String methodName) {
        super(name, clazz, returnType, methodName, 3);
    }

    /**
     * public D methodName(A x, B x, C z);
     */
    public Function3(
            final java.lang.String name,
            final Object target,
            final Class<?> returnType,
            final java.lang.String methodName) {
        super(name, target, returnType, methodName, 3);
    }

    /**
     * public static T methodName(A x, B x, C z, ...);
     */
    protected Function3(
            final java.lang.String name,
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String methodName,
            final int nParams) {
        super(name, clazz, returnType, methodName, nParams);
    }

    /**
     * public T methodName(A x, B x, C z, ...);
     */
    protected Function3(
            final java.lang.String name,
            final Object target,
            final Class<?> returnType,
            final java.lang.String methodName,
            final int nParams) {
        super(name, target, returnType, methodName, nParams);
    }

    /**
     * public static D name(A x, B y, C z);
     */
    public Function3(
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String name,
            final Class<A> typeA,
            final Class<B> typeB,
            final Class<C> typeC) {
        super(name, clazz, returnType, name, typeA, typeB, typeC);
    }

    /**
     * public D name(A x, B y, C z);
     */
    public Function3(
            final Object target,
            final Class<?> returnType,
            final java.lang.String name,
            final Class<A> typeA,
            final Class<B> typeB,
            final Class<C> typeC) {
        super(name, target, returnType, name, typeA, typeB, typeC);
    }

    /**
     * public static T methodName(A x, B y, ...);
     */
    public Function3(
            final java.lang.String name,
            final Class<?> clazz,
            final Class<?> returnType,
            final java.lang.String methodName,
            final Class<?>... paramTypes) {
        super(name, clazz, returnType, methodName, paramTypes);
    }

    /**
     * public T methodName(A x, B y, ...);
     */
    public Function3(
            final java.lang.String name,
            final Object target,
            final Class<?> returnType,
            final java.lang.String methodName,
            final Class<?>... paramTypes) {
        super(name, target, returnType, methodName, paramTypes);
    }

    /**
     * f x y
     */
    @Override
    public final Function<C, D> apply(final A x, final B y) {
        return new Function<C, D>(toString(x, y)) {
            @Override
            public D apply(final C z) {
                return Function3.this.apply(x, y, z);
            }
        };
    }

    /**
     * f x y z
     */
    public D apply(final A x, final B y, final C z) {
        return $internal().apply(this, x, y, z);
    }

}
