package haskell.prelude;

import haskell.lang.Exp;

public abstract class AbstractEq<A extends AbstractEq<A>>
        extends AbstractShow<A>
        implements Eq<A> {

    protected AbstractEq(final java.lang.String name) {
        super(name);
    }

    protected AbstractEq(
            final java.lang.String name,
            final Internal internal) {
        super(name, internal);
    }

    protected AbstractEq(final Exp<A> expression) {
        super(expression);
    }

    // ---- class Eq

    /**
     * this == x
     */
    @SuppressWarnings("unchecked")
    public final Bool _eq_(final A x) {
        return _Eq_().eq((A) this, x);
    }

    /**
     * this /= x
     */
    @SuppressWarnings("unchecked")
    public final Bool _ne_(final A x) {
        return _Eq_().ne((A) this, x);
    }

    @SuppressWarnings("unchecked")
    protected Eq.Support<A> _Eq_() {
        return new Support((Class<A>) getClass());
    }

    protected static class Support<A extends Eq<A>>
            extends Eq.Support<A> {

        protected Support(final java.lang.Class<A> a) {
            super(a);
        }

        @Override
        public Bool eq(final A x, final A y) {
            return Bool.valueOf(x.equals(y));
        }

    }

}
