package jp.sourceforge.glad.util;

import junit.framework.TestCase;

public class ValueHolderTest extends TestCase {

    public void testInteger() {
        ValueHolder<Integer> holder = new ValueHolder<Integer>();
        assertNull(holder.get());
        holder.set(123);
        assertEquals(Integer.valueOf(123), holder.get());
        holder = new ValueHolder<Integer>(456);
        assertEquals(Integer.valueOf(456), holder.get());
        holder = new ValueHolder<Integer>(holder);
        assertEquals(Integer.valueOf(456), holder.get());
    }

    public void testString() {
        ValueHolder<String> holder = new ValueHolder<String>();
        assertNull(holder.get());
        holder.set("abc");
        assertEquals("abc", holder.get());
        holder = new ValueHolder<String>("def");
        assertEquals("def", holder.get());
        holder = new ValueHolder<String>(holder);
        assertEquals("def", holder.get());
    }

}
