package jp.sourceforge.glad.dsl.xhtml;

/**
 * Example XHTML Document.
 * 
 * @author GLAD!!
 */
public class ExampleXhtml extends XhtmlDocumentSupport<ExampleXhtml> {{
    add(xml().version("1.0").encoding("UTF-8"))
    .add(DOCTYPE_xhtml10_transitional())
    .add(html().xmlns("http://www.w3.org/1999/xhtml").xml_lang("ja").lang("ja")
        .add(head()
            .add(meta().http_equiv("Content-Type")
                    .content("text/html; chatset=UTF-8"))
            .add(title().text("Example XHTML"))
            .add(link().rel("stylesheet").type("text/css")
                    .href("../../css/example/example.css"))
        )
        .add(body()
            .add(div().id("header")
                .add(h1().text("Example XHTML"))
            )
            .add(div().id("menu")
                .add(h2().add(a().id("menu").text("Menu")))
                .add(ul()
                    .add(li().add(a().href("#paragraph").text("Paragraph")))
                    .add(li().add(a().href("#table").text("Table")))
                )
            )
            .add(div().id("main")
                .add(h2().add(a().id("paragraph").text("Paragraph Example")))
                .add(p()
                    .text("This is an example XHTML Document.")
                )
                .add(h2().add(a().id("table").text("Table Example")))
                .add(table()
                    .add(thead()
                        .add(tr()
                            .add(th().text("No."))
                            .add(th().text("Name"))
                            .add(th().text("Address"))
                        )
                    )
                    .add(tbody()
                        .add(tr()
                            .add(td().text(1))
                            .add(td().text("鈴木一郎"))
                            .add(td().text("東京都港区1-2-3"))
                        )
                        .add(tr()
                            .add(td().text(2))
                            .add(td().text("山田花子"))
                            .add(td().text("横浜市西区2-3-4"))
                        )
                    )
                )
            )
        )
    );
}}
