package jp.sourceforge.glad.collection;

import junit.framework.TestCase;

public class SortedSetAdapterTest extends TestCase {

    public void testAddAll() {
        SortedSetAdapter<String> set = new SortedSetAdapter<String>()
            .addAll("1", "4", "3", "2", "4");
        assertAdapterEquals("[1, 2, 3, 4]", set);
        assertSame(set, set.addAll("b", "a"));
        assertAdapterEquals("[1, 2, 3, 4, a, b]", set);
    }

    static void assertAdapterEquals(String expected, SetAdapter<?> actual) {
        assertEquals(expected, actual.toString());
    }

}
