package jp.sourceforge.glad.calendar.joda.format;

import junit.framework.TestCase;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class JapaneseDateTimeFormatTest extends TestCase {

    static final DateTimeZone UTC = DateTimeZone.UTC;
    static final DateTimeZone JST = DateTimeZone.forID("Asia/Tokyo");

    public void testJISDate() {
        DateTimeFormatter fmt = JapaneseDateTimeFormat.jisDate();
        DateTime dateTime = new DateTime(2008, 1, 23, 1, 12, 23, 123, JST);
        assertEquals("H20.01.23", fmt.print(dateTime));
        dateTime = dateTime.withZone(UTC);
        assertEquals("H20.01.23", fmt.print(dateTime));
    }

    public void testJISDateTime() {
        DateTimeFormatter fmt = JapaneseDateTimeFormat.jisDateTime();
        DateTime dateTime = new DateTime(2008, 1, 23, 1, 12, 23, 123, JST);
        assertEquals("H20.01.23T01:12:23.123+09:00", fmt.print(dateTime));
        fmt = fmt.withZone(UTC);
        assertEquals("H20.01.22T16:12:23.123Z", fmt.print(dateTime));
    }

}
