package jp.sourceforge.glad.collection.predicate;

import jp.sourceforge.glad.collection.function.Function;

public class PredicateAdapter<S, T> implements Predicate<S> {

    private final Function<S, T> converter;

    private final Predicate<T> predicate;

    public PredicateAdapter(Function<S, T> converter, Predicate<T> predicate) {
        this.converter = converter;
        this.predicate = predicate;
    }

    public PredicateAdapter(Predicate<T> predicate, Function<S, T> converter) {
        this(converter, predicate);
    }

    /**
     * このコンストラクタを使用する場合は、convert(S) メソッドをオーバライドしてください。
     * 
     * @param predicate Predicate
     */
    protected PredicateAdapter(Predicate<T> predicate) {
        this(null, predicate);
    }

    public boolean evaludate(S source) throws Exception {
        return predicate.evaludate(convert(source));
    }

    protected T convert(S source) throws Exception {
        return converter.apply(source);
    }

}
