package jp.sourceforge.glad.collection;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SortedMapAdapter<K, V> extends MapAdapter<K, V> {

    public SortedMapAdapter() {
        this(new TreeMap<K, V>());
    }

    public SortedMapAdapter(SortedMap<K, V> map) {
        super(map);
    }

    public SortedMap<K, V> map() {
        return (SortedMap<K, V>) map;
    }

    public SortedMapAdapter<K, V> put(K key, V value) {
        super.put(key, value);
        return this;
    }

    public SortedMapAdapter<K, V> putAll(Map<? extends K, ? extends V> t) {
        super.putAll(t);
        return this;
    }

    public SortedMapAdapter<K, V> remove(Object key) {
        super.remove(key);
        return this;
    }

    public SortedMapAdapter<K, V> clear() {
        super.clear();
        return this;
    }

    public Comparator<? super K> comparator() {
        return map().comparator();
    }

    public K firstKey() {
        return map().firstKey();
    }

    public K lastKey() {
        return map().lastKey();
    }

    public SortedMap<K, V> headMap(K toKey) {
        return map().headMap(toKey);
    }

    public SortedMap<K, V> tailMap(K fromKey) {
        return map().tailMap(fromKey);
    }

    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return map().subMap(fromKey, toKey);
    }

    public SortedMap<K, V> unmodifiableMap() {
        return Collections.unmodifiableSortedMap(map());
    }

    public SortedMap<K, V> synchronizedMap() {
        return Collections.synchronizedSortedMap(map());
    }

    public SortedMap<K, V> checkedMap(Class<K> keyType, Class<V> valueType) {
        return Collections.checkedSortedMap(map(), keyType, valueType);
    }

}
