package jp.sourceforge.glad.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class SetAdapter<E> extends CollectionAdapter<E> {

    public SetAdapter() {
        this(new LinkedHashSet<E>());
    }

    public SetAdapter(Set<E> set) {
        super(set);
    }

    public Set<E> collection() {
        return set();
    }

    public Set<E> set() {
        return (Set<E>) collection;
    }

    // this ∪ {o}

    public SetAdapter<E> add(E o) {
        super.add(o);
        return this;
    }

    // this ∪ c

    public SetAdapter<E> addAll(E... a) {
        super.addAll(a);
        return this;
    }

    public SetAdapter<E> addAll(Collection<? extends E> c) {
        super.addAll(c);
        return this;
    }

    public SetAdapter<E> addAll(CollectionAdapter<? extends E> ca) {
        super.addAll(ca);
        return this;
    }

    public SetAdapter<E> addAll(Iterable<? extends E> i) {
        super.addAll(i);
        return this;
    }

    public SetAdapter<E> addAll(Iterator<? extends E> i) {
        super.addAll(i);
        return this;
    }

    public SetAdapter<E> addAll(Enumeration<? extends E> e) {
        super.addAll(e);
        return this;
    }

    // this - {c}

    public SetAdapter<E> remove(Object o) {
        super.remove(o);
        return this;
    }

    // this - c

    public SetAdapter<E> removeAll(Object... a) {
        super.removeAll(a);
        return this;
    }

    public SetAdapter<E> removeAll(Collection<?> c) {
        super.removeAll(c);
        return this;
    }

    public SetAdapter<E> removeAll(CollectionAdapter<?> ca) {
        super.removeAll(ca);
        return this;
    }

    // this ∩ c

    public SetAdapter<E> retainAll(E... a) {
        super.retainAll(a);
        return this;
    }

    public SetAdapter<E> retainAll(Collection<?> c) {
        super.retainAll(c);
        return this;
    }

    public SetAdapter<E> retainAll(CollectionAdapter<? extends E> ca) {
        super.retainAll(ca);
        return this;
    }

    public SetAdapter<E> clear() {
        super.clear();
        return this;
    }

    public Set<E> unmodifiableCollection() {
        return unmodifiableSet();
    }

    public Set<E> unmodifiableSet() {
        return Collections.unmodifiableSet(set());
    }

    public Set<E> synchronizedCollection() {
        return synchronizedSet();
    }

    public Set<E> synchronizedSet() {
        return Collections.synchronizedSet(set());
    }

    public Set<E> checkedCollection(Class<E> type) {
        return checkedSet(type);
    }

    public Set<E> checkedSet(Class<E> type) {
        return Collections.checkedSet(set(), type);
    }

}
