package example.hello.service.impl;

import example.hello.dto.HelloRequest;
import example.hello.exception.HelloException;
import junit.framework.TestCase;

public class HelloServiceBeanTest extends TestCase {

    HelloServiceBean service;

    @Override
    protected void setUp() throws Exception {
        service = new HelloServiceBean();
    }

    @Override
    protected void tearDown() throws Exception {
        service = null;
    }

    public void testSayHello() throws HelloException {
        assertEquals("Hello, World!", doSayHello(null));
        assertEquals("Hello, World!", doSayHello(""));
        assertEquals("Hello, World!", doSayHello(" "));
        assertEquals("Hello, John!", doSayHello("John"));
    }

    String doSayHello(String name) throws HelloException {
        return service.sayHello(new HelloRequest(name)).getMessage();
    }

    public void testSayHello_Null() throws HelloException {
        try {
            service.sayHello(null);
            fail();
        } catch (NullPointerException e) {}
    }

}
