package example.hello.service.proxy;

import example.common.handler.HandlerResolverImpl;
import example.common.handler.SoapClientSideHandler;
import example.common.handler.SoapMessageDumpHandler;
import example.hello.dto.HelloRequest;
import example.hello.dto.HelloResponse;
import example.hello.exception.HelloException;
import example.hello.service.HelloService;
import example.hello.service.ws.ejb.WsEjbHelloService;

public class WsEjbHelloServiceProxy implements HelloService {

    public HelloResponse sayHello(HelloRequest request) throws HelloException {
        WsEjbHelloService service = new WsEjbHelloService();
        HandlerResolverImpl handlerResolver = new HandlerResolverImpl();
        handlerResolver.addHandler(new SoapClientSideHandler());
        handlerResolver.addHandler(new SoapMessageDumpHandler());
        service.setHandlerResolver(handlerResolver);
        HelloService port = service.getPort(HelloService.class);
        return port.sayHello(request);
    }

}
