package jp.sourceforge.glad.example.web.action;

import static org.easymock.EasyMock.*;
import jp.sourceforge.glad.example.service.hello.HelloService;
import jp.sourceforge.glad.example.service.hello.dto.MessageDto;
import junit.framework.TestCase;

public class IndexActionTest extends TestCase {

    IndexAction action;

    protected void setUp() throws Exception {
        action = new IndexAction();
        action.helloService = createMock(HelloService.class);
    }

    protected void tearDown() throws Exception {
        action = null;
    }

    public void testIndex() {
        final String NAME = "SAStruts & Mayaa";
        expect(action.helloService.sayHello(eq(NAME)))
        .andReturn(new MessageDto(NAME, "Hello, SAStruts & Mayaa!"));
        replay(action.helloService);
        
        String result = action.index();
        assertEquals("index.html", result);
        assertEquals(NAME, action.message.getName());
        assertEquals("Hello, SAStruts & Mayaa!", action.message.getBody());
        verify(action.helloService);
    }

}
