#include "../gintenlib/to_string.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>


#include <iostream>
using namespace std;

// テストクラス（単純な例）
struct hoge
{
  // これから to_string が定義される
  friend ostream& operator<<( ostream& lhs, const hoge& )
  {
    return lhs << "hoge";
  }
  
};

// テストクラス２
struct fuga
{
  // operator<< の他に
  friend ostream& operator<<( ostream& lhs, const fuga& )
  {
    return lhs << "fuga::operator<<";
  }
  
  // friend 関数 to_string を定義するとどうなる？
  friend string to_string( const fuga& )
  {
    return "fuga::to_string";
  }
  
};

// テストしてみる
int test_main( int, char** )
{
  using gintenlib::to_string;
  
  // まず組み込み型
  BOOST_CHECK( gintenlib::to_string(23) == "23" );
  BOOST_CHECK( to_string(42) == "42" ); // using してるので無修飾でも使える
  BOOST_CHECK( gintenlib::to_str(108) == "108" ); // 短縮名
  
  // ユーザ定義型１
  hoge h;
  // 全て operator<< から定義される。簡単
  BOOST_CHECK( gintenlib::to_string(h) == "hoge" );
  BOOST_CHECK( to_string(h) == "hoge" );
  BOOST_CHECK( gintenlib::to_str(h) == "hoge" );
  
  // ユーザ定義型で、 operator<< の他に to_string が定義されている場合
  fuga f;
  // gintenlib::to_string は operator<< から呼ばれる
  BOOST_CHECK( gintenlib::to_string(f) == "fuga::operator<<" );
  // 無修飾の to_string は ADL によって fuga に特化したバージョンが呼ばれる
  BOOST_CHECK( to_string(f) == "fuga::to_string" );
  // gintenlib::to_str は using 宣言してから無修飾で to_string したのと同じ効果になる
  BOOST_CHECK( gintenlib::to_str(f) == "fuga::to_string" );
  
  return 0;
}
