// ヘッダ
#include "../gintenlib/to_shared.hpp"
#include "../gintenlib/intrusive_to_shared.hpp"
#include "../gintenlib/reference_counter.hpp"

// 仮テストコードなので
// boost.test はまだ使わない。

#include <iostream>
using namespace std;

// デバッグ用マクロ
#define PRINT_AND_EXECUTE( expr ) \
  cout << #expr << ";\n"; expr

#define PRINT_EXPR( expr ) \
  cout << #expr << " -> " << (expr) << endl

// 持たせるクラス
struct hoge
  : gintenlib::reference_counter<hoge>
{
  hoge()
  {
    cout << "hoge::hoge();\n";
  }
  
  hoge( const hoge& )
    : gintenlib::reference_counter<hoge>()
  {
    cout << "hoge::hoge( const hoge& );\n";
  }
  
  ~hoge() throw ()
  {
    cout << "hoge::~hoge();\n";
  }
  
};

// 適当な俺俺スマートポインタを作る

// 深いコピーを行っても格納出来ることを示すため、
// 簡易版 deep_ptr で試してみる（ gintenlib::deep_ptr は専用の to_shared が呼ばれるので）
#include <gintenlib/pointer_facade.hpp>
#include <boost/scoped_ptr.hpp>
template< typename T >
struct my_deep_ptr
  : gintenlib::pointer_facade< my_deep_ptr<T>, T >
{
  // デフォルトコンストラクタ
  my_deep_ptr() : p() {}

  // ポインタから作るコンストラクタ
  explicit my_deep_ptr( T* p_ )
     : p( p_ ) {}
  
  // コピーコンストラクタ
  my_deep_ptr( const my_deep_ptr& src )
     : p( src.p ? new T( *src.p ) : 0 ) {}
  
  // デストラクタ
  // scoped_ptr() のおかげで何もしなくていい
  // ~my_deep_ptr(){}
  
  // nothrow swap ( for operator= )
  void swap( my_deep_ptr& other )
  {
    p.swap( other.p );
  }
  friend void swap( my_deep_ptr& one, my_deep_ptr& another )
  {
    one.swap( another );
  }
  
  // 代入演算は copy して swap
  my_deep_ptr& operator=( const my_deep_ptr& src )
  {
    my_deep_ptr( src ).swap( *this );
    return *this;
  }
  
  void reset( T* p_ = 0 )
  {
    my_deep_ptr( p_ ).swap( *this );
  }
  
  // get pointer
  // これと pointer_facade からいろいろと自動生成
  T* get() const { return p.get(); }
  
 private:
  boost::scoped_ptr<T> p;

};  // class my_deep_ptr<T>

// 汎用版はまだテストしない。 intrusive, auto をチェック
int main()
{
  // intrusive 
  {
    // pointer 版
    PRINT_AND_EXECUTE( gintenlib::intrusive_to_shared( new hoge() ) );
    
    boost::intrusive_ptr<hoge> p1;
    PRINT_AND_EXECUTE( p1 = new hoge() );
    
    boost::shared_ptr<hoge> p2;
    // to_shared 変換
    PRINT_AND_EXECUTE( p2 = gintenlib::to_shared(p1) );
    // ちゃんと同じオブジェクト？
    PRINT_EXPR( p1.get() == p2.get() );
    // もともとの intrusive を reset しても大丈夫かチェック
    PRINT_AND_EXECUTE( p1.reset() );
    
    // 抜けます
    cout << "scope out: p1, p2\n";
  }
  
  // auto
  {
    std::auto_ptr<hoge> p1;
    PRINT_AND_EXECUTE( p1.reset( new hoge() ) );
    PRINT_EXPR( p1.get() );
    boost::shared_ptr<hoge> p2;
    PRINT_AND_EXECUTE( p2 = gintenlib::to_shared(p1) );
    
    // ちゃんと所有権移動できているかチェック
    PRINT_EXPR( p1.get() );
    PRINT_EXPR( p2.get() );
    
    // おまけ。trivial なやつ
    PRINT_AND_EXECUTE( gintenlib::to_shared(p2) );
    
    // 抜けます
    cout << "scope out: p1, p2\n";
  }
  
  // ユーザ定義クラス
  {
    my_deep_ptr<hoge> p1;
    PRINT_AND_EXECUTE( p1.reset( new hoge() ) );
    PRINT_EXPR( p1.get() );
    boost::shared_ptr<hoge> p2;
    PRINT_AND_EXECUTE( p2 = gintenlib::to_shared(p1) );
    
    // ちゃんと深いコピーできているかチェック
    PRINT_EXPR( p1.get() );
    PRINT_EXPR( p2.get() );
    
    // 抜けます
    cout << "scope out: p1, p2\n";
  }
  
  return 0;
}

