// ヘッダ
#include "../gintenlib/storage.hpp"

// boost の単体テストフレームワーク
#include <boost/test/minimal.hpp>

#include <boost/type_traits.hpp>

// テスト
template<typename T>
void test()
{
  // 型定義
  typedef gintenlib::storage<T> storage_type;
  typedef typename gintenlib::storage_of<T>::type raw_storage;
  
  // 型審査
  BOOST_CHECK(( boost::is_same<typename storage_type::storage_type, raw_storage>::value ));
  
  // raw storage に対して
  BOOST_CHECK(( sizeof( raw_storage ) == sizeof( T ) ));
  BOOST_CHECK(( boost::is_pod<raw_storage>::value ));
  
  // storage に対して
  BOOST_CHECK(( sizeof( storage_type ) == sizeof( T ) ));
  BOOST_CHECK(( boost::has_trivial_destructor<storage_type>::value ));
  
  // アドレスのチェック
  storage_type x;
  BOOST_CHECK(( &x == x.address() ));
}

// 対象のクラス群
struct empty_class {};

struct virtual_class
{
  virtual ~virtual_class() {}
  int member;
};

int test_main( int, char** )
{
  test<int>();
  test<int const>();
  test<int*>();
  test<empty_class>();
  test<virtual_class>();
  
  return 0;
}

